/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationContentTypeCleaner;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationPreparedStatementSetter;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class CleanAndStoreConfigurationInTransaction
extends TransactionCallbackWithoutResult {
    private final JdbcTemplate jdbcTemplate;
    private final List<BonitaConfiguration> bonitaConfigurations;
    private final ConfigurationType type;
    private final long tenantId;
    private final String dbVendor;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    public CleanAndStoreConfigurationInTransaction(JdbcTemplate jdbcTemplate, String dbVendor, List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type, long tenantId) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbVendor = dbVendor;
        this.bonitaConfigurations = bonitaConfigurations;
        this.type = type;
        this.tenantId = tenantId;
    }

    protected void doInTransactionWithoutResult(TransactionStatus status) {
        LOGGER.debug("delete existing configurations for type:" + this.type.name() + " and tenant id:" + this.tenantId);
        this.jdbcTemplate.batchUpdate("DELETE from configuration where tenant_id = ? and content_type = ? ", (BatchPreparedStatementSetter)new BonitaConfigurationContentTypeCleaner(this.type, this.tenantId));
        this.jdbcTemplate.batchUpdate("INSERT into configuration(tenant_id, content_type, resource_name, resource_content) values (?,?,?,?)", (BatchPreparedStatementSetter)new BonitaConfigurationPreparedStatementSetter(this.bonitaConfigurations, this.dbVendor, this.type, this.tenantId));
    }
}

