/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import org.bonitasoft.platform.configuration.impl.BonitaConfigurationTenantCleaner;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class DeleteTenantConfigurationInTransaction
extends TransactionCallbackWithoutResult {
    private final JdbcTemplate jdbcTemplate;
    private final long tenantId;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    public DeleteTenantConfigurationInTransaction(JdbcTemplate jdbcTemplate, long tenantId) {
        this.jdbcTemplate = jdbcTemplate;
        this.tenantId = tenantId;
    }

    protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
        LOGGER.info("delete existing configurations for tenant id:" + this.tenantId);
        this.jdbcTemplate.batchUpdate("DELETE FROM configuration WHERE tenant_id = ?", (BatchPreparedStatementSetter)new BonitaConfigurationTenantCleaner(this.tenantId));
    }
}

