/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaAllConfigurationPreparedStatementSetter;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class StoreConfigurationsIfNotExist
extends TransactionCallbackWithoutResult {
    public static final String SELECT_CONFIGURATION_EXISTS = "SELECT count(1) FROM configuration WHERE tenant_id = ? AND content_type = ? AND resource_name = ?";
    private final JdbcTemplate jdbcTemplate;
    private final String dbVendor;
    private final List<FullBonitaConfiguration> configurations;

    public StoreConfigurationsIfNotExist(JdbcTemplate jdbcTemplate, String dbVendor, List<FullBonitaConfiguration> configurations) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbVendor = dbVendor;
        this.configurations = configurations;
    }

    public void doInTransactionWithoutResult(TransactionStatus status) {
        for (FullBonitaConfiguration configuration : this.configurations) {
            Integer nbRows = (Integer)this.jdbcTemplate.queryForObject(SELECT_CONFIGURATION_EXISTS, Integer.class, new Object[]{configuration.getTenantId(), configuration.getConfigurationType(), configuration.getResourceName()});
            if (nbRows == 0) {
                ConfigurationServiceImpl.LOGGER.info("New configuration file detected '{}'. Storing it to database.", (Object)configuration.getResourceName());
                this.jdbcTemplate.batchUpdate("INSERT into configuration(tenant_id, content_type, resource_name, resource_content) values (?,?,?,?)", (BatchPreparedStatementSetter)new BonitaAllConfigurationPreparedStatementSetter(Collections.singletonList(configuration), this.dbVendor));
                continue;
            }
            ConfigurationServiceImpl.LOGGER.debug("Configuration already exists for type: {}, resource: {} and tenant id: {}. Ignoring it.", new Object[]{configuration.getConfigurationType(), configuration.getResourceName(), configuration.getTenantId()});
        }
    }
}

