/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application.xml;

import org.bonitasoft.engine.business.application.ApplicationState;
import org.bonitasoft.engine.business.application.xml.ApplicationMenuNode;
import org.bonitasoft.engine.business.application.xml.ApplicationNode;
import org.bonitasoft.engine.business.application.xml.ApplicationNodeContainer;
import org.bonitasoft.engine.business.application.xml.ApplicationPageNode;

public class ApplicationNodeBuilder {
    private ApplicationNodeBuilder() {
    }

    public static ApplicationNodeContainerBuilder newApplicationContainer() {
        return new ApplicationNodeContainerBuilder();
    }

    public static ApplicationBuilder newApplication(String token, String displayName, String version) {
        return new ApplicationBuilder(token, displayName, version);
    }

    public static PageBuilder newApplicationPage(String customPage, String token) {
        return new PageBuilder(customPage, token);
    }

    public static MenuBuilder newMenu(String displayName, String page) {
        return new MenuBuilder(displayName, page);
    }

    public static class MenuBuilder {
        private final ApplicationMenuNode applicationMenu = new ApplicationMenuNode();

        public MenuBuilder(String displayName, String applicationPage) {
            this.applicationMenu.setDisplayName(displayName);
            this.applicationMenu.setApplicationPage(applicationPage);
        }

        public MenuBuilder havingMenu(MenuBuilder ... menuBuilders) {
            for (MenuBuilder applicationMenuBuilder : menuBuilders) {
                this.applicationMenu.addApplicationMenu(applicationMenuBuilder.create());
            }
            return this;
        }

        public ApplicationMenuNode create() {
            return this.applicationMenu;
        }
    }

    public static class PageBuilder {
        private final ApplicationPageNode applicationPage = new ApplicationPageNode();

        public PageBuilder(String customPage, String token) {
            this.applicationPage.setCustomPage(customPage);
            this.applicationPage.setToken(token);
        }

        public ApplicationPageNode create() {
            return this.applicationPage;
        }
    }

    public static class ApplicationBuilder {
        private final ApplicationNode applicationNode = new ApplicationNode();

        public ApplicationBuilder(String token, String displayName, String version) {
            this.applicationNode.setToken(token);
            this.applicationNode.setDisplayName(displayName);
            this.applicationNode.setVersion(version);
            this.applicationNode.setState(ApplicationState.ACTIVATED.name());
        }

        public ApplicationBuilder withHomePage(String homePage) {
            this.applicationNode.setHomePage(homePage);
            return this;
        }

        public ApplicationBuilder withDescription(String description) {
            this.applicationNode.setDescription(description);
            return this;
        }

        public ApplicationBuilder withIconPath(String iconPath) {
            this.applicationNode.setIconPath(iconPath);
            return this;
        }

        public ApplicationBuilder withProfile(String profile) {
            this.applicationNode.setProfile(profile);
            return this;
        }

        public ApplicationBuilder withLayout(String layout) {
            this.applicationNode.setLayout(layout);
            return this;
        }

        public ApplicationBuilder withTheme(String theme) {
            this.applicationNode.setTheme(theme);
            return this;
        }

        public ApplicationBuilder havingApplicationPages(PageBuilder ... applicationPageBuilders) {
            for (PageBuilder applicationPageBuilder : applicationPageBuilders) {
                this.applicationNode.addApplicationPage(applicationPageBuilder.create());
            }
            return this;
        }

        public ApplicationBuilder havingApplicationMenus(MenuBuilder ... applicationMenuBuilders) {
            for (MenuBuilder applicationMenuBuilder : applicationMenuBuilders) {
                this.applicationNode.addApplicationMenu(applicationMenuBuilder.create());
            }
            return this;
        }

        public ApplicationNode create() {
            return this.applicationNode;
        }
    }

    public static class ApplicationNodeContainerBuilder {
        private final ApplicationNodeContainer applicationNodeContainer = new ApplicationNodeContainer();

        public ApplicationNodeContainerBuilder havingApplications(ApplicationBuilder ... applicationBuilders) {
            for (ApplicationBuilder applicationBuilder : applicationBuilders) {
                this.applicationNodeContainer.addApplication(applicationBuilder.create());
            }
            return this;
        }

        public ApplicationNodeContainer create() {
            return this.applicationNodeContainer;
        }
    }
}

