/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bonitasoft.engine.api.internal.ServerAPI;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.session.Session;

public class ClientInterceptor
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -6284726148297940515L;
    private final ServerAPI api;
    private final String interfaceName;
    private final Session session;
    private static final Logger LOGGER = Logger.getLogger(ClientInterceptor.class.getName());

    public ClientInterceptor(String interfaceName, ServerAPI api, Session session) {
        this.api = api;
        this.interfaceName = interfaceName;
        this.session = session;
    }

    public ClientInterceptor(String interfaceName, ServerAPI api) {
        this(interfaceName, api, null);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<String> classNameParameters = new ArrayList<String>();
            for (Class<?> parameterType : parameterTypes) {
                classNameParameters.add(parameterType.getName());
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Calling method " + method.getName() + " on API " + this.api.getClass().getName());
            }
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("session", this.session);
            Object object = this.api.invokeMethod(options, this.interfaceName, method.getName(), classNameParameters, args);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Quitting method " + method.getName() + " on API " + this.api.getClass().getName());
            }
            return object;
        }
        catch (RemoteException | ServerWrappedException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Quitting method " + method.getName() + " on API " + this.api.getClass().getName() + " with exception " + e.getMessage());
            }
            throw e.getCause();
        }
    }
}

