/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class CustomOffsetDateTimeDeserializer
extends StdDeserializer<OffsetDateTime> {
    public CustomOffsetDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    public OffsetDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = (String)jp.readValueAs(String.class);
        if (value == null) {
            return null;
        }
        return OffsetDateTime.parse(value).withOffsetSameInstant(ZoneOffset.UTC);
    }
}

