/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.NamedElement;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;

public class UniqueNameValidator {
    public ValidationStatus validate(Collection<? extends NamedElement> namedElements, String namedElementTypePluralForm) {
        ValidationStatus status = new ValidationStatus();
        Set<String> duplicateNames = this.findDuplicateNames(namedElements);
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("bdmArtifact", (Serializable)((Object)namedElementTypePluralForm));
        for (String name : duplicateNames) {
            context.put("bdmArtifactName", (Serializable)((Object)name));
            status.addError(StatusCode.DUPLICATE_CONSTRAINT_OR_INDEX_NAME, String.format("There are at least two %s with the same name : %s", namedElementTypePluralForm, name), context);
        }
        return status;
    }

    private Set<String> findDuplicateNames(Collection<? extends NamedElement> list) {
        LinkedHashSet<String> duplicates = new LinkedHashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (NamedElement namedElement : list) {
            if (uniqueNames.add(namedElement.getName())) continue;
            duplicates.add(namedElement.getName());
        }
        return duplicates;
    }
}

