/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.QueryParameter;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class QueryParameterValidationRule
extends ValidationRule<QueryParameter, ValidationStatus> {
    public static final List<String> FORBIDDEN_PARAMETER_NAMES = Arrays.asList("startIndex", "maxResults");

    public QueryParameterValidationRule() {
        super(QueryParameter.class);
    }

    @Override
    public ValidationStatus validate(QueryParameter parameter) {
        ValidationStatus status = new ValidationStatus();
        String name = parameter.getName();
        if (name == null || name.isEmpty()) {
            status.addError(StatusCode.QUERY_PARAMETER_WITHOUT_NAME, "A parameter must have name");
            return status;
        }
        if (!SourceVersion.isIdentifier(name)) {
            status.addError(StatusCode.INVALID_JAVA_IDENTIFIER_NAME, String.format("%s is not a valid Java identifier.", name), Collections.singletonMap("bdmArtifactName", name));
        }
        if (FORBIDDEN_PARAMETER_NAMES.contains(name)) {
            status.addError(StatusCode.FORBIDDEN_QUERY_PARAMETER_NAME, String.format("%s is a reserved parameter name. Use a name different from: %s", name, FORBIDDEN_PARAMETER_NAMES), Collections.singletonMap("bdmArtifactName", name));
        }
        if (parameter.getClassName() == null || parameter.getClassName().isEmpty()) {
            status.addError(StatusCode.QUERY_PARAMETER_WITHOUT_CLASS_NAME, String.format("%s query parameter must have a classname", name), Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }
}

