/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

public abstract class ValidationRule<T, R> {
    private Class<T> classToApply;

    public ValidationRule(Class<T> classToApply) {
        this.classToApply = classToApply;
    }

    public boolean appliesTo(Object modelElement) {
        return modelElement != null && this.classToApply.isAssignableFrom(modelElement.getClass());
    }

    protected abstract R validate(T var1);

    public R checkRule(Object modelElement) {
        if (!this.appliesTo(modelElement)) {
            throw new IllegalArgumentException(this.getClass().getName() + " doesn't handle validation for " + modelElement.getClass().getName());
        }
        return this.validate(modelElement);
    }
}

