/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.business.application.ApplicationField;

public class ApplicationUpdater
implements Serializable {
    private static final long serialVersionUID = 4565052647320534796L;
    private final Map<ApplicationField, Serializable> fields = new HashMap<ApplicationField, Serializable>(8);

    public Map<ApplicationField, Serializable> getFields() {
        return this.fields;
    }

    public ApplicationUpdater setToken(String token) {
        this.fields.put(ApplicationField.TOKEN, (Serializable)((Object)token));
        return this;
    }

    public ApplicationUpdater setDisplayName(String displayName) {
        this.fields.put(ApplicationField.DISPLAY_NAME, (Serializable)((Object)displayName));
        return this;
    }

    public ApplicationUpdater setVersion(String version) {
        this.fields.put(ApplicationField.VERSION, (Serializable)((Object)version));
        return this;
    }

    public ApplicationUpdater setDescription(String description) {
        this.fields.put(ApplicationField.DESCRIPTION, (Serializable)((Object)description));
        return this;
    }

    @Deprecated(since="7.13.0")
    public ApplicationUpdater setIconPath(String iconPath) {
        this.fields.put(ApplicationField.ICON_PATH, (Serializable)((Object)iconPath));
        return this;
    }

    public ApplicationUpdater setIcon(String iconFileName, byte[] content) {
        this.fields.put(ApplicationField.ICON_FILE_NAME, (Serializable)((Object)iconFileName));
        this.fields.put(ApplicationField.ICON_CONTENT, (Serializable)content);
        return this;
    }

    public ApplicationUpdater setState(String state) {
        this.fields.put(ApplicationField.STATE, (Serializable)((Object)state));
        return this;
    }

    public ApplicationUpdater setProfileId(Long profileId) {
        this.fields.put(ApplicationField.PROFILE_ID, profileId);
        return this;
    }

    public ApplicationUpdater setHomePageId(Long applicationPageId) {
        this.fields.put(ApplicationField.HOME_PAGE_ID, applicationPageId);
        return this;
    }

    public boolean hasFields() {
        return !this.getFields().isEmpty();
    }
}

