/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.connector.sap;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Properties;

public class SAPMonoDestinationDataProvider
implements DestinationDataProvider {
    private static SAPMonoDestinationDataProvider destinationDataProvider = null;
    private DestinationDataEventListener listener;
    private Properties properties;
    private final String destinationName;

    private SAPMonoDestinationDataProvider(String destinationName) {
        this.destinationName = destinationName;
    }

    public static synchronized SAPMonoDestinationDataProvider getInstance(String destinationName) throws IllegalStateException {
        if (destinationDataProvider == null) {
            destinationDataProvider = new SAPMonoDestinationDataProvider(destinationName);
            Environment.registerDestinationDataProvider((DestinationDataProvider)destinationDataProvider);
        } else if (!destinationName.equals(destinationDataProvider.getDestinationName())) {
            throw new IllegalStateException("You can use only one SAP destination (and they should use the configuration). The current one is named " + destinationDataProvider.getDestinationName());
        }
        return destinationDataProvider;
    }

    public Properties getDestinationProperties(String destinationName) {
        if (destinationName.equals(this.destinationName) && this.properties != null) {
            return this.properties;
        }
        throw new RuntimeException("Destination " + destinationName + " is not available");
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
        this.listener = eventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    public void changeProperties(Properties properties) {
        if (properties == null) {
            this.listener.deleted(this.destinationName);
            this.properties = null;
        } else {
            if (this.listener != null && !properties.equals(this.properties)) {
                this.listener.updated(this.destinationName);
            }
            this.properties = properties;
        }
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public static void clear() {
        if (destinationDataProvider != null) {
            Environment.unregisterDestinationDataProvider((DestinationDataProvider)destinationDataProvider);
            destinationDataProvider = null;
        }
    }
}

