/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.engine.identity.ContactDataCreator;

public class UserCreator
implements Serializable {
    private static final long serialVersionUID = -1414989152963184543L;
    private final Map<UserField, Serializable> fields = new HashMap<UserField, Serializable>(5);
    private final Map<ContactDataCreator.ContactDataField, Serializable> persoFields;
    private final Map<ContactDataCreator.ContactDataField, Serializable> proFields;

    public UserCreator(String name, String password) {
        this.fields.put(UserField.NAME, (Serializable)((Object)name));
        this.fields.put(UserField.PASSWORD, (Serializable)((Object)password));
        this.persoFields = new HashMap<ContactDataCreator.ContactDataField, Serializable>();
        this.proFields = new HashMap<ContactDataCreator.ContactDataField, Serializable>();
    }

    public UserCreator setFirstName(String firstName) {
        this.fields.put(UserField.FIRST_NAME, (Serializable)((Object)firstName));
        return this;
    }

    public UserCreator setLastName(String lastName) {
        this.fields.put(UserField.LAST_NAME, (Serializable)((Object)lastName));
        return this;
    }

    @Deprecated
    public UserCreator setIconName(String iconName) {
        return this;
    }

    @Deprecated
    public UserCreator setIconPath(String iconPath) {
        return this;
    }

    public UserCreator setTitle(String title) {
        this.fields.put(UserField.TITLE, (Serializable)((Object)title));
        return this;
    }

    public UserCreator setJobTitle(String jobTitle) {
        this.fields.put(UserField.JOB_TITLE, (Serializable)((Object)jobTitle));
        return this;
    }

    public UserCreator setManagerUserId(long managerUserId) {
        this.fields.put(UserField.MANAGER_ID, Long.valueOf(managerUserId));
        return this;
    }

    public UserCreator setEnabled(boolean enabled) {
        this.fields.put(UserField.ENABLED, Boolean.valueOf(enabled));
        return this;
    }

    public Map<UserField, Serializable> getFields() {
        return this.fields;
    }

    public Map<ContactDataCreator.ContactDataField, Serializable> getPersoFields() {
        return this.persoFields;
    }

    public Map<ContactDataCreator.ContactDataField, Serializable> getProFields() {
        return this.proFields;
    }

    public UserCreator setPersonalContactData(ContactDataCreator creator) {
        if (creator != null && creator.getFields() != null) {
            this.persoFields.putAll(creator.getFields());
        }
        return this;
    }

    public UserCreator setProfessionalContactData(ContactDataCreator creator) {
        if (creator != null && creator.getFields() != null) {
            this.proFields.putAll(creator.getFields());
        }
        return this;
    }

    public UserCreator setIcon(String filename, byte[] content) {
        this.fields.put(UserField.ICON_FILENAME, (Serializable)((Object)filename));
        this.fields.put(UserField.ICON_CONTENT, (Serializable)content);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCreator that = (UserCreator)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.persoFields, that.persoFields) && Objects.equals(this.proFields, that.proFields);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.persoFields, this.proFields);
    }

    public String toString() {
        return "UserCreator{fields=" + this.fields + ", persoFields=" + this.persoFields + ", proFields=" + this.proFields + "}";
    }

    public static enum UserField {
        NAME,
        PASSWORD,
        FIRST_NAME,
        LAST_NAME,
        ICON_NAME,
        ICON_PATH,
        TITLE,
        JOB_TITLE,
        MANAGER_ID,
        ENABLED,
        ICON_FILENAME,
        ICON_CONTENT;

    }
}

