/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.tenant;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.bonitasoft.engine.bpm.BonitaObject;
import org.bonitasoft.engine.tenant.TenantResourceState;
import org.bonitasoft.engine.tenant.TenantResourceType;

public class TenantResource
implements BonitaObject {
    public static final TenantResource NONE = new TenantResource(0L, "", null, 0L, 0L, null);
    private long id;
    private String name;
    private TenantResourceType type;
    private OffsetDateTime lastUpdateDate;
    private long lastUpdatedBy;
    private TenantResourceState state;

    public TenantResource(long id, String name, TenantResourceType type, long lastUpdateDate, long lastUpdatedBy, TenantResourceState state) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.lastUpdateDate = OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastUpdateDate), ZoneOffset.UTC);
        this.lastUpdatedBy = lastUpdatedBy;
        this.state = state;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TenantResourceType getType() {
        return this.type;
    }

    public TenantResourceState getState() {
        return this.state;
    }

    public OffsetDateTime getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public long getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }
}

