/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.extension.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.bonitasoft.web.extension.rest.RestApiResponse;

public class RestApiResponseBuilder {
    protected Serializable response;
    protected int httpStatus = 200;
    protected final Map<String, String> additionalHeaders = new HashMap<String, String>();
    protected final List<Cookie> additionalCookies = new ArrayList<Cookie>();
    protected String characterSet = RestApiResponse.DEFAULT_CHARACTER_SET;
    protected String mediaType = "application/json";
    private int pageIndex = -1;
    private int pageSize = -1;
    private long totalSize = -1L;

    public RestApiResponseBuilder withResponse(Serializable response) {
        this.response = response;
        return this;
    }

    public RestApiResponseBuilder withResponseStatus(int httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    public RestApiResponseBuilder withAdditionalHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
        return this;
    }

    public RestApiResponseBuilder withAdditionalCookie(Cookie cookie) {
        this.additionalCookies.add(cookie);
        return this;
    }

    public RestApiResponseBuilder withCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public RestApiResponseBuilder withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public RestApiResponseBuilder withContentRange(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        return this;
    }

    public RestApiResponseBuilder withContentRange(int pageIndex, int pageSize, long totalSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalSize = totalSize;
        return this;
    }

    public RestApiResponse build() {
        if (this.pageIndex >= 0 && this.pageSize >= 0) {
            this.additionalHeaders.put("Content-Range", String.format("%s-%s/%s", this.pageIndex, this.pageSize, this.totalSize >= 0L ? Long.valueOf(this.totalSize) : "*"));
        }
        return new RestApiResponse(this.response, this.httpStatus, this.additionalHeaders, this.additionalCookies, this.mediaType, this.characterSet);
    }
}

