/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.io.File;
import java.nio.file.Path;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;

public class FolderResolver {
    private final Path configurationFolder;
    private final Path licenseFolder;

    public FolderResolver(Path configurationFolder, Path licenseFolder) {
        this.configurationFolder = configurationFolder;
        this.licenseFolder = licenseFolder;
    }

    public File getFolder(FullBonitaConfiguration fullBonitaConfiguration) {
        File confFolder = this.resolveFolder(fullBonitaConfiguration).toFile();
        confFolder.mkdirs();
        return confFolder;
    }

    private Path resolveSubFolder(Path rootPath, FullBonitaConfiguration fullBonitaConfiguration) {
        if (fullBonitaConfiguration.isLicenseFile()) {
            return rootPath;
        }
        if (fullBonitaConfiguration.isTenantFile()) {
            return rootPath.resolve("tenants").resolve(fullBonitaConfiguration.getTenantId().toString()).resolve(fullBonitaConfiguration.getConfigurationType().toLowerCase());
        }
        return rootPath.resolve(fullBonitaConfiguration.getConfigurationType().toLowerCase());
    }

    private Path resolveFolder(FullBonitaConfiguration fullBonitaConfiguration) {
        if (fullBonitaConfiguration.isLicenseFile()) {
            return this.resolveSubFolder(this.licenseFolder, fullBonitaConfiguration);
        }
        return this.resolveSubFolder(this.configurationFolder, fullBonitaConfiguration);
    }
}

