/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.bonitasoft.platform.setup.jndi.SimpleNameParser;

public class SimpleMemoryContext
implements Context {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private final Map<String, Object> dictionary = new ConcurrentHashMap<String, Object>();

    public void clear() {
        this.dictionary.clear();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (this.dictionary.containsKey(name)) {
            return this.dictionary.get(name);
        }
        throw new NameNotFoundException("Name " + name + " is not bound !");
    }

    @Override
    public void bind(Name name, Object o) throws NamingException {
        this.bind(name.toString(), o);
    }

    @Override
    public void bind(String name, Object o) throws NamingException {
        if (this.dictionary.containsKey(name)) {
            throw new NameAlreadyBoundException("Name " + name + " already bound!");
        }
        this.rebind(name, o);
    }

    @Override
    public void rebind(Name name, Object o) {
        this.rebind(name.toString(), o);
    }

    @Override
    public void rebind(String name, Object o) {
        this.dictionary.put(name, o);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (!this.dictionary.containsKey(name)) {
            throw new NameNotFoundException("No such name " + name + " is bound!");
        }
        this.dictionary.remove(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Object object = this.lookup(oldName);
        this.bind(newName, object);
        this.unbind(oldName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void destroySubcontext(Name name) {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) {
        this.dictionary.remove(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        SimpleMemoryContext subContext = new SimpleMemoryContext();
        this.bind(name, (Object)subContext);
        return subContext;
    }

    @Override
    public Object lookupLink(Name name) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public Object lookupLink(String string) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public NameParser getNameParser(Name name) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public NameParser getNameParser(String name) {
        return new SimpleNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name name1) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public String composeName(String string, String string1) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public Object addToEnvironment(String string, Object o) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

