/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bonitasoft.engine.bpm.bar.ActorMappingContribution;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.ClasspathContribution;
import org.bonitasoft.engine.bpm.bar.ConnectorContribution;
import org.bonitasoft.engine.bpm.bar.DocumentsResourcesContribution;
import org.bonitasoft.engine.bpm.bar.ExternalResourceContribution;
import org.bonitasoft.engine.bpm.bar.FormMappingContribution;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.bar.ParameterContribution;
import org.bonitasoft.engine.bpm.bar.ProcessDefinitionBARContribution;
import org.bonitasoft.engine.bpm.bar.UserFilterContribution;

public class BusinessArchiveFactory {
    private static final List<BusinessArchiveContribution> contributions = new ArrayList<BusinessArchiveContribution>();
    private static final BusinessArchiveFactory INSTANCE;
    private static final int BUFFER_SIZE = 100000;

    public static BusinessArchive readBusinessArchive(InputStream inputStream) throws IOException, InvalidBusinessArchiveFormatException {
        return INSTANCE.readBusinessArchive(inputStream, contributions);
    }

    public static BusinessArchive readBusinessArchive(File barOrFolder) throws InvalidBusinessArchiveFormatException, IOException {
        return INSTANCE.readBusinessArchive(barOrFolder, contributions);
    }

    public static void writeBusinessArchiveToFolder(BusinessArchive businessArchive, File folderPath) throws IOException {
        INSTANCE.writeBusinessArchiveToFolder(businessArchive, folderPath, contributions);
    }

    public static void writeBusinessArchiveToFile(BusinessArchive businessArchive, File businessArchiveFile) throws IOException {
        File tempFile = Files.createTempDirectory("tempBarFolder", new FileAttribute[0]).toFile();
        try {
            BusinessArchiveFactory.writeBusinessArchiveToFolder(businessArchive, tempFile);
            BusinessArchiveFactory.zipBarFolder(businessArchiveFile, tempFile);
        }
        finally {
            BusinessArchiveFactory.deleteDir(tempFile.toPath());
        }
    }

    public static String businessArchiveFolderToFile(File destFile, String folderPath) throws IOException {
        BusinessArchiveFactory.zipBarFolder(destFile, new File(folderPath));
        return destFile.getAbsolutePath();
    }

    protected BusinessArchive readBusinessArchive(InputStream inputStream, List<BusinessArchiveContribution> contributions) throws IOException, InvalidBusinessArchiveFormatException {
        File barFolder = Files.createTempDirectory("tempBarFolder", new FileAttribute[0]).toFile();
        try {
            BusinessArchiveFactory.unzipToFolder(inputStream, barFolder);
            BusinessArchive businessArchive = this.getBusinessArchive(barFolder, contributions);
            return businessArchive;
        }
        catch (InvalidBusinessArchiveFormatException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidBusinessArchiveFormatException("Invalid format, can't read the BAR file", e);
        }
        finally {
            BusinessArchiveFactory.deleteDir(barFolder.toPath());
        }
    }

    protected BusinessArchive readBusinessArchive(File barOrFolder, List<BusinessArchiveContribution> contributions) throws InvalidBusinessArchiveFormatException, IOException {
        if (!barOrFolder.exists()) {
            throw new FileNotFoundException("the file does not exists: " + barOrFolder.getAbsolutePath());
        }
        if (barOrFolder.isDirectory()) {
            return this.getBusinessArchive(barOrFolder, contributions);
        }
        try (FileInputStream inputStream = new FileInputStream(barOrFolder);){
            BusinessArchive businessArchive = BusinessArchiveFactory.readBusinessArchive(inputStream);
            return businessArchive;
        }
    }

    private BusinessArchive getBusinessArchive(File barFolder, List<BusinessArchiveContribution> contributions) throws IOException, InvalidBusinessArchiveFormatException {
        BusinessArchive businessArchive = new BusinessArchive();
        for (BusinessArchiveContribution contribution : contributions) {
            if (contribution.readFromBarFolder(businessArchive, barFolder) || !contribution.isMandatory()) continue;
            throw new InvalidBusinessArchiveFormatException("Invalid format, can't read '" + contribution.getName() + "' from the BAR file");
        }
        return businessArchive;
    }

    protected void writeBusinessArchiveToFolder(BusinessArchive businessArchive, File folderPath, List<BusinessArchiveContribution> contributions) throws IOException {
        if (folderPath.exists()) {
            if (!folderPath.isDirectory()) {
                throw new IOException("unable to create Business archive on a file " + folderPath);
            }
        } else {
            folderPath.mkdirs();
        }
        for (BusinessArchiveContribution contribution : contributions) {
            contribution.saveToBarFolder(businessArchive, folderPath);
        }
    }

    private static void deleteDir(Path directory) throws IOException {
        try (Stream<Path> pathStream = Files.walk(directory, new FileVisitOption[0]);){
            pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipBarFolder(File businessArchiveFile, File folder) throws IOException {
        if (businessArchiveFile.exists()) {
            throw new IOException("The destination file already exists " + businessArchiveFile.getAbsolutePath());
        }
        try (FileOutputStream fileOutput = new FileOutputStream(businessArchiveFile);
             ZipOutputStream zos = new ZipOutputStream(fileOutput);){
            BusinessArchiveFactory.zipDir(folder.getAbsolutePath(), zos, folder.getAbsolutePath());
        }
    }

    private static void unzipToFolder(InputStream inputStream, File outputFolder) throws IOException {
        try (ZipInputStream zipInputstream = new ZipInputStream(inputStream);){
            BusinessArchiveFactory.extractZipEntries(zipInputstream, outputFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipEntries(ZipInputStream zipInputstream, File outputFolder) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputstream.getNextEntry()) != null) {
            try {
                File outputFile = new File(outputFolder.getAbsolutePath(), zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (outputFile.exists()) continue;
                    outputFile.mkdirs();
                    continue;
                }
                BusinessArchiveFactory.writeZipInputToFile(zipInputstream, outputFile);
            }
            finally {
                zipInputstream.closeEntry();
            }
        }
    }

    private static void writeZipInputToFile(ZipInputStream zipInputstream, File outputFile) throws IOException {
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            int bytesRead;
            byte[] buffer = new byte[100000];
            while ((bytesRead = zipInputstream.read(buffer)) > -1) {
                fileOutputStream.write(buffer, 0, bytesRead);
            }
            fileOutputStream.flush();
        }
        catch (IOException ioe) {
            Files.delete(outputFile.toPath());
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDir(String dir2zip, ZipOutputStream zos, String root) throws IOException {
        File zipDir = new File(dir2zip);
        byte[] readBuffer = new byte[100000];
        for (String pathName : zipDir.list()) {
            File file = new File(zipDir, pathName);
            String path = file.getPath();
            if (file.isDirectory()) {
                BusinessArchiveFactory.zipDir(path, zos, root);
                continue;
            }
            try {
                ZipEntry anEntry = new ZipEntry(path.substring(root.length() + 1, path.length()).replace(String.valueOf(File.separatorChar), "/"));
                zos.putNextEntry(anEntry);
                BusinessArchiveFactory.copyFileToZip(zos, readBuffer, file);
                zos.flush();
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    private static void copyFileToZip(ZipOutputStream zos, byte[] readBuffer, File file) throws IOException {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int bytesIn;
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
            }
        }
    }

    static {
        contributions.add(new ProcessDefinitionBARContribution());
        contributions.add(new ParameterContribution());
        contributions.add(new ConnectorContribution());
        contributions.add(new ExternalResourceContribution());
        contributions.add(new ActorMappingContribution());
        contributions.add(new UserFilterContribution());
        contributions.add(new DocumentsResourcesContribution());
        contributions.add(new ClasspathContribution());
        contributions.add(new FormMappingContribution());
        INSTANCE = new BusinessArchiveFactory();
    }
}

