/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBException;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.bpm.bar.form.model.FormMappingModel;
import org.bonitasoft.engine.bpm.form.FormMappingModelMarshaller;
import org.xml.sax.SAXException;

public class FormMappingContribution
implements BusinessArchiveContribution {
    public static final String FORM_MAPPING_FILE = "form-mapping.xml";

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return "FormMapping";
    }

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        Path file = barFolder.toPath().resolve(FORM_MAPPING_FILE);
        if (Files.exists(file, new LinkOption[0])) {
            byte[] content = Files.readAllBytes(file);
            try {
                businessArchive.setFormMappings(new FormMappingModelMarshaller().deserializeFromXML(content));
            }
            catch (JAXBException | SAXException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        FormMappingModel formMappingModel = businessArchive.getFormMappingModel();
        try {
            byte[] fileContent = new FormMappingModelMarshaller().serializeToXML(formMappingModel);
            Files.write(barFolder.toPath().resolve(FORM_MAPPING_FILE), fileContent, new OpenOption[0]);
        }
        catch (JAXBException | SAXException e) {
            throw new IOException("Cannot write Form Mapping Model to Bar folder", e);
        }
    }
}

