/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.bonitasoft.engine.bpm.internal.LongToStringAdapter;
import org.bonitasoft.engine.bpm.process.ModelFinderVisitor;
import org.bonitasoft.engine.expression.Expression;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionImpl
implements Expression {
    private static final long serialVersionUID = 1663953453575781859L;
    @XmlID
    @XmlJavaTypeAdapter(type=long.class, value=LongToStringAdapter.class)
    @XmlAttribute
    private long id;
    @XmlAttribute
    private String name;
    @XmlElement
    private String content;
    @XmlAttribute
    private String expressionType;
    @XmlAttribute
    private String returnType;
    @XmlAttribute
    private String interpreter;
    @XmlElement(type=ExpressionImpl.class, name="expression")
    private List<Expression> dependencies = new ArrayList<Expression>();

    private long generateId() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    @Override
    public Expression copy() {
        try {
            ExpressionImpl clone = (ExpressionImpl)this.clone();
            clone.setId(this.generateId());
            ArrayList<Expression> depList = new ArrayList<Expression>(this.getDependencies().size());
            for (Expression expression : this.getDependencies()) {
                depList.add(expression.copy());
            }
            clone.setDependencies(depList);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void accept(ModelFinderVisitor visitor, long modelId) {
        visitor.find(this, modelId);
    }

    @Override
    public boolean isEquivalent(Expression e) {
        if (this == e) {
            return true;
        }
        if (e == null || this.getClass() != e.getClass()) {
            return false;
        }
        return Objects.equals(this.name, e.getName()) && Objects.equals(this.content, e.getContent()) && Objects.equals(this.expressionType, e.getExpressionType()) && Objects.equals(this.returnType, e.getReturnType()) && Objects.equals(this.interpreter, e.getInterpreter()) && Objects.equals(this.dependencies, e.getDependencies());
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getExpressionType() {
        return this.expressionType;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getInterpreter() {
        return this.interpreter;
    }

    @Override
    public List<Expression> getDependencies() {
        return this.dependencies;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setInterpreter(String interpreter) {
        this.interpreter = interpreter;
    }

    public void setDependencies(List<Expression> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionImpl)) {
            return false;
        }
        ExpressionImpl other = (ExpressionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$expressionType = this.getExpressionType();
        String other$expressionType = other.getExpressionType();
        if (this$expressionType == null ? other$expressionType != null : !this$expressionType.equals(other$expressionType)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        String this$interpreter = this.getInterpreter();
        String other$interpreter = other.getInterpreter();
        if (this$interpreter == null ? other$interpreter != null : !this$interpreter.equals(other$interpreter)) {
            return false;
        }
        List<Expression> this$dependencies = this.getDependencies();
        List<Expression> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExpressionImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $expressionType = this.getExpressionType();
        result = result * 59 + ($expressionType == null ? 43 : $expressionType.hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        String $interpreter = this.getInterpreter();
        result = result * 59 + ($interpreter == null ? 43 : $interpreter.hashCode());
        List<Expression> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    public String toString() {
        return "ExpressionImpl(id=" + this.getId() + ", name=" + this.getName() + ", content=" + this.getContent() + ", expressionType=" + this.getExpressionType() + ", returnType=" + this.getReturnType() + ", interpreter=" + this.getInterpreter() + ", dependencies=" + this.getDependencies() + ")";
    }
}

