/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import org.glassfish.hk2.osgiresourcelocator.ResourceFinder;

public class SQLNameValidator {
    private static final int DEFAULT_MAX_LENGTH = 255;
    private static final String SQL_KEYWORDS_RESOURCE = "/sql_keywords";
    private final int maxLength;
    static Set<String> sqlKeywords = new HashSet<String>();

    public SQLNameValidator() {
        this(255);
    }

    public SQLNameValidator(int maxLength) {
        this.maxLength = maxLength;
        if (sqlKeywords.isEmpty()) {
            this.initializeSQLKeywords();
        }
    }

    private void initializeSQLKeywords() {
        try (Scanner scanner = new Scanner(this.getSQLKeywordsResource());){
            while (scanner.hasNext()) {
                String word = scanner.nextLine();
                sqlKeywords.add(word.trim());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private InputStream getSQLKeywordsResource() throws IOException {
        URL sqlKeywordsResource = Optional.ofNullable(ResourceFinder.findEntry((String)SQL_KEYWORDS_RESOURCE)).orElseGet(() -> SQLNameValidator.class.getResource(SQL_KEYWORDS_RESOURCE));
        if (sqlKeywordsResource == null) {
            throw new FileNotFoundException("SQL Keywords resource not found");
        }
        return sqlKeywordsResource.openStream();
    }

    public boolean isValid(String name) {
        return name.matches("[a-zA-Z][\\d\\w#@]{0," + this.maxLength + "}$") && !this.isSQLKeyword(name);
    }

    public boolean isSQLKeyword(String name) {
        return sqlKeywords.contains(name.toUpperCase());
    }
}

