/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.bonitasoft.engine.api.BonitaStackTraceElementConverter;
import org.bonitasoft.engine.exception.BonitaRuntimeException;

public class XmlConverter {
    private static final XStream XSTREAM = new XStream();

    public String toXML(Object object) {
        StringWriter stringWriter = new StringWriter();
        try (ObjectOutputStream out = XSTREAM.createObjectOutputStream((Writer)stringWriter);){
            out.writeObject(object);
        }
        catch (IOException e) {
            throw new BonitaRuntimeException("Unable to serialize object " + object, (Throwable)e);
        }
        return stringWriter.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <T> T fromXML(String object) {
        try (StringReader xmlReader = new StringReader(object);){
            Object object2;
            block13: {
                ObjectInputStream in = XSTREAM.createObjectInputStream((Reader)xmlReader);
                try {
                    object2 = in.readObject();
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException | RuntimeException e) {
            throw new BonitaRuntimeException("Unable to deserialize object " + object, (Throwable)e);
        }
    }

    static {
        XSTREAM.ignoreUnknownElements();
        XStream.setupDefaultSecurity((XStream)XSTREAM);
        XSTREAM.addPermission(AnyTypePermission.ANY);
        XSTREAM.registerConverter((SingleValueConverter)new BonitaStackTraceElementConverter(), 10000);
    }
}

