/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth;

import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerProperties;
import org.bonitasoft.console.common.server.auth.impl.standard.StandardAuthenticationManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AuthenticationManagerFactory.class.getName());
    static AuthenticationManager authenticationManager;

    public static AuthenticationManager getAuthenticationManager() throws AuthenticationManagerNotFoundException {
        String authenticationManagerName = null;
        if (authenticationManager == null) {
            try {
                authenticationManagerName = AuthenticationManagerFactory.getManagerImplementationClassName();
                authenticationManager = (AuthenticationManager)Class.forName(authenticationManagerName).newInstance();
            }
            catch (Exception e) {
                String message = "The AuthenticationManager implementation " + authenticationManagerName + " does not exist!";
                throw new AuthenticationManagerNotFoundException(message);
            }
        }
        return authenticationManager;
    }

    private static String getManagerImplementationClassName() {
        String authenticationManagerName = AuthenticationManagerProperties.getProperties().getAuthenticationManagerImpl();
        if (authenticationManagerName == null || authenticationManagerName.isEmpty()) {
            authenticationManagerName = StandardAuthenticationManagerImpl.class.getName();
            LOGGER.trace("The login manager implementation is undefined. Using default implementation : " + authenticationManagerName);
        }
        return authenticationManagerName;
    }
}

