/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.auth.impl.standard;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import org.bonitasoft.console.common.server.auth.AuthenticationFailedException;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.credentials.Credentials;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAuthenticationManagerImpl
implements AuthenticationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)StandardAuthenticationManagerImpl.class.getName());

    @Override
    public String getLoginPageURL(HttpServletRequestAccessor request, String redirectURL) throws ServletException {
        StringBuilder url = new StringBuilder();
        String context = request.asHttpServletRequest().getContextPath();
        url.append(context).append("/login.jsp").append("?");
        String localeFromRequestedURL = LocaleUtils.getLocaleFromRequestURL(request.asHttpServletRequest());
        if (localeFromRequestedURL != null) {
            url.append("_l").append("=").append(localeFromRequestedURL).append("&");
        }
        url.append("redirectUrl").append("=").append(redirectURL);
        return url.toString();
    }

    @Override
    public Map<String, Serializable> authenticate(HttpServletRequestAccessor requestAccessor, Credentials credentials) throws AuthenticationFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("#authenticate (this implementation of " + AuthenticationManager.class.getName() + " does nothing. The subsequent engine login is enough to authenticate the user.)");
        }
        return Collections.emptyMap();
    }

    @Override
    public String getLogoutPageURL(HttpServletRequestAccessor request, String redirectURL) throws ServletException {
        return null;
    }
}

