/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.filter.URLExcludePattern;

public abstract class ExcludingPatternFilter
implements Filter {
    protected URLExcludePattern urlExcludePattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.urlExcludePattern = new URLExcludePattern(filterConfig, this.getDefaultExcludedPages());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = ((HttpServletRequest)request).getRequestURL().toString();
        if (this.matchExcludePatterns(url)) {
            this.excludePatternFiltering(request, response, chain);
        } else {
            this.proceedWithFiltering(request, response, chain);
        }
    }

    public void excludePatternFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public abstract void proceedWithFiltering(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public abstract String getDefaultExcludedPages();

    public Pattern compilePattern(String stringPattern) {
        return this.urlExcludePattern.compilePattern(stringPattern);
    }

    public boolean matchExcludePatterns(String url) {
        return this.urlExcludePattern.matchExcludePatterns(url);
    }

    public Pattern getExcludePattern() {
        return this.urlExcludePattern.getExcludePattern();
    }
}

