/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class SanitizerFilter
extends ExcludingPatternFilter {
    private static final PolicyFactory sanitizer = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(Sanitizers.STYLES).and(Sanitizers.IMAGES);
    private static final String[] CONCERNED_METHODS = new String[]{"POST", "PUT", "PATCH"};
    private ObjectMapper mapper = new ObjectMapper();
    private boolean isEnabled = PropertiesFactory.getSecurityProperties().isSanitizerProtectionEnabled();
    private List<String> attributesExcluded = PropertiesFactory.getSecurityProperties().getAttributeExcludedFromSanitizerProtection();

    @Override
    public void destroy() {
    }

    @Override
    public String getDefaultExcludedPages() {
        return "";
    }

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req;
        block6: {
            block5: {
                req = (HttpServletRequest)request;
                String method = req.getMethod();
                if (!this.isSanitizerEnabled() || method == null) break block5;
                if (!Stream.of(CONCERNED_METHODS).noneMatch(method::equalsIgnoreCase)) break block6;
            }
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        JsonNode body = this.getJsonBody(req);
        Optional<JsonNode> sanitized = this.sanitize(body);
        if (sanitized.isPresent()) {
            final byte[] saneBodyBytes = this.mapper.writeValueAsBytes((Object)sanitized.get());
            sanitized.get();
            HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(req){
                private ServletInputStream inputStream;
                {
                    super(request);
                    this.inputStream = null;
                }

                public ServletInputStream getInputStream() throws IOException {
                    if (this.inputStream == null) {
                        final ByteArrayInputStream is = new ByteArrayInputStream(saneBodyBytes);
                        this.inputStream = new ServletInputStream(){

                            public int read() throws IOException {
                                return is.read();
                            }

                            public boolean isFinished() {
                                return is.available() == 0;
                            }

                            public boolean isReady() {
                                return !this.isFinished();
                            }

                            public void setReadListener(ReadListener readListener) {
                                throw new UnsupportedOperationException("Unimplemented method 'setReadListener'");
                            }
                        };
                    }
                    return this.inputStream;
                }

                public int getContentLength() {
                    return saneBodyBytes.length;
                }

                public long getContentLengthLong() {
                    return saneBodyBytes.length;
                }
            };
            chain.doFilter((ServletRequest)wrapper, response);
        } else {
            chain.doFilter((ServletRequest)req, response);
        }
    }

    protected Optional<JsonNode> sanitize(JsonNode node) {
        if (node == null) {
            return Optional.empty();
        }
        if (node.isObject()) {
            AtomicBoolean changed = new AtomicBoolean(false);
            ObjectNode object = (ObjectNode)node;
            ArrayList operationsToPerformAfterIteration = new ArrayList();
            object.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                String newKey = this.sanitizeValueAndPerformAction(key, s -> {
                    operationsToPerformAfterIteration.add(() -> {
                        object.remove(key);
                        object.set(s, (JsonNode)entry.getValue());
                    });
                    changed.set(true);
                }).orElse(key);
                if (this.getAttributesExcluded() == null || !this.getAttributesExcluded().contains(key)) {
                    JsonNode value = (JsonNode)entry.getValue();
                    this.sanitize(value).ifPresent(v -> {
                        object.set(newKey, v);
                        changed.set(true);
                    });
                }
            });
            operationsToPerformAfterIteration.forEach(Runnable::run);
            return changed.get() ? Optional.of(object) : Optional.empty();
        }
        if (node.isArray()) {
            AtomicBoolean changed = new AtomicBoolean(false);
            ArrayNode array = (ArrayNode)node;
            int i = 0;
            while (i < array.size()) {
                JsonNode value = array.get(i);
                int index = i++;
                this.sanitize(value).ifPresent(v -> {
                    array.set(index, v);
                    changed.set(true);
                });
            }
            return changed.get() ? Optional.of(array) : Optional.empty();
        }
        if (node.isValueNode()) {
            if (node.isBoolean() || node.isNumber() || node.isPojo() || StringUtils.isEmpty((Object)node.textValue())) {
                return Optional.empty();
            }
            Optional<String> changedValue = this.sanitizeValueAndPerformAction(node.textValue(), v -> {});
            return changedValue.map(TextNode::new);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode getJsonBody(HttpServletRequest request) throws ServletException {
        if (request.getContentType() == null) return null;
        if (!request.getContentType().toLowerCase().startsWith("application/json")) return null;
        try (ServletInputStream inputStream = request.getInputStream();){
            if (inputStream == null) {
                JsonNode jsonNode = null;
                return jsonNode;
            }
            String characterEncoding = Optional.ofNullable(request.getCharacterEncoding()).orElse("UTF-8");
            String stringBody = IOUtils.toString((InputStream)inputStream, (String)characterEncoding);
            if (stringBody.isBlank()) return null;
            JsonNode jsonNode = this.mapper.readTree(stringBody);
            return jsonNode;
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Optional<String> sanitizeValueAndPerformAction(String value, Consumer<String> action) {
        String previous = value;
        String unescaped = HtmlUtils.htmlUnescape((String)previous);
        while (!unescaped.equals(previous)) {
            previous = unescaped;
            unescaped = HtmlUtils.htmlUnescape((String)previous);
        }
        String sanitized = sanitizer.sanitize(unescaped);
        if (!(sanitized = HtmlUtils.htmlUnescape((String)sanitized)).equals(value)) {
            action.accept(sanitized);
            return Optional.of(sanitized);
        }
        return Optional.empty();
    }

    public List<String> getAttributesExcluded() {
        return this.attributesExcluded;
    }

    public boolean isSanitizerEnabled() {
        return this.isEnabled;
    }
}

