/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.engine.session.APISession;

public class HttpServletRequestAccessor {
    protected static final String REDIRECT_URL = "redirectUrl";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    private static final String OAUTH_VERIFIER = "oauth_verifier";
    private static final String OAUTH_TOKEN = "oauth_token";
    private final HttpServletRequest httpServletRequest;

    public HttpServletRequestAccessor(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public String getUsername() {
        return this.httpServletRequest.getParameter(USERNAME_PARAM);
    }

    public String getPassword() {
        return this.httpServletRequest.getParameter(PASSWORD_PARAM);
    }

    public HttpSession getHttpSession() {
        return this.httpServletRequest.getSession();
    }

    public String getRedirectUrl() {
        return this.httpServletRequest.getParameter(REDIRECT_URL);
    }

    public String getOAuthToken() {
        return this.httpServletRequest.getParameter(OAUTH_TOKEN);
    }

    public String getOAuthVerifier() {
        return this.httpServletRequest.getParameter(OAUTH_VERIFIER);
    }

    public APISession getApiSession() {
        return (APISession)this.getHttpSession().getAttribute("apiSession");
    }

    public Map<String, String[]> getParameterMap() {
        return this.httpServletRequest.getParameterMap();
    }

    public String getRequestedUrl() {
        return this.httpServletRequest.getRequestURL().toString();
    }

    public String getRequestedUri() {
        return this.httpServletRequest.getRequestURI();
    }

    public HttpServletRequest asHttpServletRequest() {
        return this.httpServletRequest;
    }

    public String getUserAgent() {
        return this.httpServletRequest.getHeader("User-Agent");
    }

    public String getLocale() {
        return LocaleUtils.getUserLocaleAsString(this.httpServletRequest);
    }
}

