/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.credentials;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.api.LoginAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.platform.LoginException;
import org.bonitasoft.engine.platform.LogoutException;
import org.bonitasoft.engine.platform.UnknownUserException;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDatastore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LoginDatastore.class.getName());

    public APISession login(String username, String password) throws BonitaException {
        APISession apiSession;
        String errorMessage = "Error while logging in the engine API.";
        try {
            if (username == null || password == null) {
                LOGGER.error("Error while logging in the engine API.");
                throw new LoginException("Error while logging in the engine API.");
            }
            apiSession = this.getLoginAPI().login(username, password);
        }
        catch (UnknownUserException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        catch (LoginException e) {
            LOGGER.error("Error while logging in the engine API.");
            throw e;
        }
        catch (BonitaException e) {
            LOGGER.error(e.getMessage());
            throw e;
        }
        return apiSession;
    }

    public APISession login(Map<String, Serializable> credentials) throws BonitaException {
        APISession apiSession;
        try {
            if (credentials == null) {
                String errorMessage = "Error while logging in on the engine API.";
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Error while logging in on the engine API.");
                }
                throw new LoginException("Error while logging in on the engine API.");
            }
            apiSession = this.getLoginAPI().login(credentials);
        }
        catch (LoginException e) {
            String errorMessage = "Error while logging in on the engine API.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while logging in on the engine API.");
            }
            throw new BonitaException((Throwable)e);
        }
        return apiSession;
    }

    public void logout(APISession apiSession) throws BonitaException {
        if (apiSession != null) {
            try {
                this.getLoginAPI().logout(apiSession);
            }
            catch (LogoutException e) {
                String errorMessage = "Logout error while calling the engine API.";
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Logout error while calling the engine API.");
                }
                throw new BonitaException("Logout error while calling the engine API.", (Throwable)e);
            }
        }
    }

    protected LoginAPI getLoginAPI() throws BonitaException {
        try {
            return TenantAPIAccessor.getLoginAPI();
        }
        catch (BonitaException e) {
            String errorMessage = "Error while getting the loginAPI.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error while getting the loginAPI.");
            }
            throw new BonitaException("Error while getting the loginAPI.", (Throwable)e);
        }
    }
}

