/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.credentials;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.console.common.server.login.LoginFailedException;
import org.bonitasoft.console.common.server.login.credentials.Credentials;
import org.bonitasoft.console.common.server.login.credentials.LoginDatastore;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;

public class UserLogger {
    public APISession doLogin(Credentials credentials) throws LoginFailedException {
        try {
            return this.getDatastore().login(credentials.getName(), credentials.getPassword());
        }
        catch (BonitaException e) {
            throw new LoginFailedException(e.getMessage(), e);
        }
    }

    public APISession doLogin(Map<String, Serializable> credentials) throws LoginFailedException {
        try {
            return this.getDatastore().login(credentials);
        }
        catch (BonitaException e) {
            throw new LoginFailedException(e.getMessage(), e);
        }
    }

    public void doLogout(APISession apiSession) throws LoginFailedException {
        try {
            this.getDatastore().logout(apiSession);
        }
        catch (BonitaException e) {
            throw new LoginFailedException(e.getMessage(), e);
        }
    }

    private LoginDatastore getDatastore() {
        return new LoginDatastore();
    }
}

