/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.preferences.properties.SecurityProperties;

public class FrameSecurityFilter
extends ExcludingPatternFilter {
    protected static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    protected static final String X_FRAME_OPTIONS_HEADER_DEFAULT = "SAMEORIGIN";
    protected static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    protected static final String CONTENT_SECURITY_POLICY_HEADER_DEFAULT = "frame-ancestors 'self';";
    protected String xFrameHeaderValue;
    protected String contentSecurityHeaderValue;

    @Override
    public String getDefaultExcludedPages() {
        return "";
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        SecurityProperties securityProperties = this.getSecurityProperties();
        String xFrameHeaderPropertyValue = securityProperties.getXFrameOptionsHeader();
        this.xFrameHeaderValue = Objects.requireNonNullElse(xFrameHeaderPropertyValue, (String)StringUtils.defaultIfEmpty((CharSequence)filterConfig.getInitParameter(X_FRAME_OPTIONS_HEADER), (CharSequence)X_FRAME_OPTIONS_HEADER_DEFAULT));
        String contentSecurityHeaderPropertyValue = securityProperties.getContentSecurityPolicyHeader();
        this.contentSecurityHeaderValue = Objects.requireNonNullElse(contentSecurityHeaderPropertyValue, (String)StringUtils.defaultIfEmpty((CharSequence)filterConfig.getInitParameter(CONTENT_SECURITY_POLICY_HEADER), (CharSequence)CONTENT_SECURITY_POLICY_HEADER_DEFAULT));
        super.init(filterConfig);
    }

    protected SecurityProperties getSecurityProperties() {
        return PropertiesFactory.getSecurityProperties();
    }

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!StringUtils.isBlank((CharSequence)this.xFrameHeaderValue)) {
            res.setHeader(X_FRAME_OPTIONS_HEADER, this.xFrameHeaderValue);
        }
        if (!StringUtils.isBlank((CharSequence)this.contentSecurityHeaderValue)) {
            res.setHeader(CONTENT_SECURITY_POLICY_HEADER, this.contentSecurityHeaderValue);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }
}

