/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.console.common.server.filter.ExcludingPatternFilter;
import org.bonitasoft.console.common.server.login.filter.MultiReadHttpServletRequest;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class TokenValidatorFilter
extends ExcludingPatternFilter {
    public static final String BEARER_HEADER_VERIFIED_ATTRIBUTE = "bearerVerified";
    private static final String CSRF_TOKEN_PARAM = "CSRFToken";
    private static final String CSRF_TOKEN_HEADER = "X-Bonita-API-Token";
    protected static final String TOKEN_VALIDATOR_FILTER_EXCLUDED_PAGES_PATTERN = "^/(bonita/)?((apps/.+/)|(portal/resource/.+/))?(API|APIToolkit)/system/(i18ntranslation|feature|session)";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)TokenValidatorFilter.class.getName());

    @Override
    public void proceedWithFiltering(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.isCsrfProtectionEnabled() && !this.isSafeMethod(httpServletRequest.getMethod()) && !this.isBearerVerifiedRequest(httpServletRequest.getSession())) {
            MultiReadHttpServletRequest multiReadHttpServletRequest = new MultiReadHttpServletRequest(httpServletRequest);
            String headerFromRequest = this.getCSRFToken((HttpServletRequest)multiReadHttpServletRequest);
            String apiToken = (String)multiReadHttpServletRequest.getSession().getAttribute("api_token");
            if (headerFromRequest == null || !headerFromRequest.equals(apiToken)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Token Validation failed, expected: " + apiToken + ", received: " + headerFromRequest);
                }
                httpServletResponse.setStatus(401);
                response.flushBuffer();
            } else {
                chain.doFilter((ServletRequest)multiReadHttpServletRequest, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean isBearerVerifiedRequest(HttpSession httpSession) {
        boolean isBearerVerified = false;
        Object bearerSessionAttribute = httpSession.getAttribute(BEARER_HEADER_VERIFIED_ATTRIBUTE);
        if (bearerSessionAttribute != null) {
            isBearerVerified = Boolean.parseBoolean((String)bearerSessionAttribute);
            httpSession.removeAttribute(BEARER_HEADER_VERIFIED_ATTRIBUTE);
        }
        return isBearerVerified;
    }

    protected boolean isCsrfProtectionEnabled() {
        return PropertiesFactory.getSecurityProperties().isCSRFProtectionEnabled();
    }

    private String getCSRFToken(HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader(CSRF_TOKEN_HEADER);
        if (StringUtils.isBlank((CharSequence)token)) {
            token = httpRequest.getParameter(CSRF_TOKEN_PARAM);
        }
        if (StringUtils.isBlank((CharSequence)token) && this.isFormData(httpRequest.getContentType())) {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
            multipartResolver.setResolveLazily(true);
            MultipartHttpServletRequest multiPartRequest = multipartResolver.resolveMultipart(httpRequest);
            if (multiPartRequest.getParameterMap().containsKey(CSRF_TOKEN_PARAM)) {
                token = multiPartRequest.getParameter(CSRF_TOKEN_PARAM);
            }
        }
        return token;
    }

    private boolean isFormData(String contentType) {
        return contentType != null && contentType.toLowerCase().contains("multipart/form-data");
    }

    private boolean isSafeMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "OPTIONS".equalsIgnoreCase(method);
    }

    @Override
    public String getDefaultExcludedPages() {
        return TOKEN_VALIDATOR_FILTER_EXCLUDED_PAGES_PATTERN;
    }
}

