/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.auth.AuthenticationFailedException;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.login.LoginFailedException;
import org.bonitasoft.console.common.server.login.LoginManager;
import org.bonitasoft.console.common.server.login.servlet.URLProtector;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlBuilder;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlHandler;
import org.bonitasoft.console.common.server.utils.LocaleUtils;
import org.bonitasoft.console.common.server.utils.TenantsManagementUtils;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.session.APISession;
import org.restlet.data.MediaType;
import org.restlet.engine.header.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = -5326931127638029215L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LoginServlet.class.getName());
    protected static final String LOGIN_FAIL_MESSAGE = "loginFailMessage";
    protected static final String LOGIN_URL_PARAM_NAME = "loginUrl";
    public static final String ENABLE_DEV_SUITE_LOGIN = "org.bonitasoft.web.login.get.enabled";

    @Deprecated(since="8.0", forRemoval=false)
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!Boolean.parseBoolean(System.getProperty(ENABLE_DEV_SUITE_LOGIN))) {
            resp.setStatus(405);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("query string : " + LoginServlet.dropPassword(req.getQueryString()));
        }
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
        if (request.getContentType() != null && !MediaType.APPLICATION_WWW_FORM.equals((Object)ContentType.readMediaType((String)request.getContentType()))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The only content type supported by this service is application/x-www-form-urlencoded. The content-type request header needs to be set accordingly.");
            }
            response.setStatus(415);
        } else {
            this.handleLogin(request, response);
        }
    }

    protected void handleLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        boolean redirectAfterLogin = RedirectUrlHandler.shouldRedirectAfterLogin(request);
        String redirectURL = this.getRedirectUrl(request, redirectAfterLogin);
        String locale = LocaleUtils.getUserLocaleAsString(request);
        try {
            this.doLogin(request, response);
            APISession apiSession = (APISession)request.getSession().getAttribute("apiSession");
            if (redirectAfterLogin) {
                if (apiSession.isTechnicalUser() || this.hasProfile(apiSession)) {
                    response.sendRedirect(this.createRedirectUrl(redirectURL, locale));
                } else {
                    request.setAttribute(LOGIN_FAIL_MESSAGE, (Object)"noProfileForUser");
                    this.getServletContext().getRequestDispatcher("/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                LocaleUtils.addOrReplaceLocaleCookieResponse(response, locale);
                response.setStatus(204);
            }
        }
        catch (AuthenticationManagerNotFoundException e) {
            String message = "Can't get login manager";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Can't get login manager", (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
        catch (LoginFailedException e) {
            this.handleException(request, response, redirectAfterLogin, e, locale);
        }
        catch (AuthenticationFailedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication failed : " + e.getMessage(), (Throwable)e);
            }
            this.handleException(request, response, redirectAfterLogin, e, locale);
        }
        catch (Exception e) {
            LOGGER.error("Error while trying to log in", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean hasProfile(APISession apiSession) throws NotFoundException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantsManagementUtils.hasProfileForUser(apiSession);
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, boolean redirectAfterLogin, Exception e, String locale) throws ServletException {
        if (redirectAfterLogin) {
            try {
                request.setAttribute(LOGIN_FAIL_MESSAGE, (Object)LOGIN_FAIL_MESSAGE);
                String loginURL = request.getParameter(LOGIN_URL_PARAM_NAME);
                if (loginURL == null) {
                    loginURL = "/login.jsp";
                    this.getServletContext().getRequestDispatcher(loginURL).forward((ServletRequest)request, (ServletResponse)response);
                }
                this.getServletContext().getRequestDispatcher(this.createRedirectUrl(loginURL, locale)).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e1) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error(e1.getMessage());
                }
                throw new ServletException((Throwable)e1);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage());
            }
            response.setStatus(401);
        }
    }

    private String getRedirectUrl(HttpServletRequest request, boolean redirectAfterLogin) {
        String redirectURL = request.getParameter("redirectUrl");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("redirecting to : " + redirectURL);
        }
        if (redirectAfterLogin && (redirectURL == null || redirectURL.isEmpty())) {
            redirectURL = "apps/appDirectoryBonita";
        } else if (redirectURL != null) {
            redirectURL = new URLProtector().protectRedirectUrl(redirectURL);
        }
        return redirectURL;
    }

    private String createRedirectUrl(String redirectURL, String locale) {
        RedirectUrlBuilder redirectUrlBuilder = new RedirectUrlBuilder(redirectURL);
        redirectUrlBuilder.appendParameter("_l", locale);
        return redirectUrlBuilder.build().getUrl();
    }

    protected void doLogin(HttpServletRequest request, HttpServletResponse response) throws AuthenticationManagerNotFoundException, LoginFailedException, ServletException, AuthenticationFailedException {
        LoginManager loginManager = this.getLoginManager();
        loginManager.login(request, response);
    }

    protected LoginManager getLoginManager() {
        return new LoginManager();
    }

    static String dropPassword(String content) {
        String tmp = content;
        if (content != null && content.contains("password")) {
            tmp = tmp.replaceAll("[&]?password=([^&|#]*)?", "");
        }
        return tmp;
    }
}

