/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.login.PortalCookies;
import org.bonitasoft.console.common.server.login.filter.TokenGenerator;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.PlatformLoginAPI;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.platform.InvalidPlatformCredentialsException;
import org.bonitasoft.engine.session.PlatformSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformLoginServlet
extends HttpServlet {
    public static final String PLATFORM_SESSION_PARAM_KEY = "platformSession";
    protected static final String USERNAME_PARAM = "username";
    protected static final String PASSWORD_PARAM = "password";
    protected static final String LOGIN_FAIL_MESSAGE = "loginFailMessage";
    private static final long serialVersionUID = -5326931127638029215L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PlatformLoginServlet.class.getName());
    protected static final String LOGIN_PAGE = "/platformLogin.jsp";
    protected static final String PLATFORM_PAGE = "platform/BonitaPlatform.html#?_p=Platform";
    public static final String ERROR_MESSAGE = "Error while logging in to the platform";
    protected final TokenGenerator tokenGenerator = new TokenGenerator();
    protected final PortalCookies portalCookies = new PortalCookies();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String username = request.getParameter(USERNAME_PARAM);
        String password = request.getParameter(PASSWORD_PARAM);
        String redirectStr = request.getParameter("redirect");
        boolean redirectAfterLogin = Boolean.parseBoolean(redirectStr);
        try {
            PlatformLoginAPI platformLoginAPI = this.getPlatformLoginAPI();
            PlatformSession platformSession = platformLoginAPI.login(username, password);
            request.getSession().setAttribute(PLATFORM_SESSION_PARAM_KEY, (Object)platformSession);
            String csrfToken = this.tokenGenerator.createOrLoadToken(request.getSession());
            this.portalCookies.addCSRFTokenCookieToResponse(request, response, csrfToken);
            if (redirectAfterLogin) {
                response.sendRedirect(PLATFORM_PAGE);
            }
        }
        catch (InvalidPlatformCredentialsException e) {
            LOGGER.trace("Wrong username or password", (Throwable)e);
            if (redirectAfterLogin) {
                response.sendError(403, "Wrong username or password");
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            LOGGER.error(ERROR_MESSAGE, (Throwable)e);
            if (redirectAfterLogin) {
                try {
                    request.setAttribute(LOGIN_FAIL_MESSAGE, (Object)LOGIN_FAIL_MESSAGE);
                    this.getServletContext().getRequestDispatcher(LOGIN_PAGE).forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException ioe) {
                    LOGGER.error("Error while redirecting to login.jsp", (Throwable)ioe);
                    throw new ServletException(ERROR_MESSAGE, (Throwable)e);
                }
            }
            throw new ServletException(ERROR_MESSAGE, (Throwable)e);
        }
    }

    PlatformLoginAPI getPlatformLoginAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return PlatformAPIAccessor.getPlatformLoginAPI();
    }
}

