/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.login.utils;

import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.login.utils.RedirectUrl;
import org.bonitasoft.console.common.server.utils.UrlBuilder;

public class RedirectUrlBuilder {
    private final UrlBuilder urlBuilder;
    private final List<String> blackList = List.of("redirectUrl");

    public RedirectUrlBuilder(String redirectUrl) {
        this.urlBuilder = new UrlBuilder(redirectUrl != null ? redirectUrl : "");
    }

    public RedirectUrl build() {
        return new RedirectUrl(this.urlBuilder.build());
    }

    public void appendParameters(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> next : parameters.entrySet()) {
            this.appendParameter(next.getKey(), next.getValue());
        }
    }

    public void appendParameter(String name, String ... values) {
        if (!this.isBlackListed(name)) {
            this.urlBuilder.appendParameter(name, values);
        }
    }

    public void removeParameter(String name) {
        this.urlBuilder.removeParameter(name);
    }

    private boolean isBlackListed(String key) {
        return this.blackList.contains(key);
    }
}

