/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.Serializable;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.livingapps.ApplicationModel;
import org.bonitasoft.livingapps.ApplicationModelFactory;

public class CustomPageAuthorizationsHelper {
    private final ApplicationAPI applicationAPI;
    private final PageAPI pageApi;
    private final APISession apiSession;
    private final ApplicationModelFactory applicationFactory;

    public CustomPageAuthorizationsHelper(APISession apiSession, ApplicationAPI applicationAPI, PageAPI pageApi, ApplicationModelFactory applicationModelFactory) {
        this.applicationAPI = applicationAPI;
        this.pageApi = pageApi;
        this.apiSession = apiSession;
        this.applicationFactory = applicationModelFactory;
    }

    public boolean isPageAuthorized(String applicationToken, String pageToken) {
        try {
            Long applicationId = this.getApplicationId(applicationToken);
            ApplicationModel application = this.applicationFactory.createApplicationModel(applicationToken);
            if (applicationId == null || !application.authorize(this.apiSession)) {
                return false;
            }
            return this.applicationAPI.searchApplicationPages(new SearchOptionsBuilder(0, 0).filter("applicationId", (Serializable)applicationId).filter("pageId", (Serializable)Long.valueOf(this.pageApi.getPageByName(pageToken).getId())).done()).getCount() > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Long getApplicationId(String applicationToken) throws BonitaException {
        SearchResult applicationSResult = this.applicationAPI.searchApplications(new SearchOptionsBuilder(0, 1).filter("token", (Serializable)((Object)applicationToken)).done());
        if (applicationSResult.getResult().isEmpty()) {
            return null;
        }
        return ((Application)applicationSResult.getResult().get(0)).getId();
    }
}

