/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPageDependenciesResolver {
    private static final String LIB_FOLDER_NAME = "lib";
    static final Map<String, File> PAGES_LIB_TMPDIR = new HashMap<String, File>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CustomPageDependenciesResolver.class.getName());
    private File libTempFolder;
    private final WebBonitaConstantsUtils webBonitaConstantsUtils;
    private final File pageDirectory;
    private final String pageName;

    public CustomPageDependenciesResolver(String pageName, File pageDirectory, WebBonitaConstantsUtils webBonitaConstantsUtils) {
        this.pageName = pageName;
        this.pageDirectory = pageDirectory;
        this.webBonitaConstantsUtils = webBonitaConstantsUtils;
    }

    public Map<String, byte[]> resolveCustomPageDependencies() {
        File customPageLibDirectory = new File(this.pageDirectory, LIB_FOLDER_NAME);
        if (customPageLibDirectory.exists()) {
            this.libTempFolder = new File(this.webBonitaConstantsUtils.getTempFolder(), this.pageName + new Date().getTime());
            if (!this.libTempFolder.exists()) {
                this.libTempFolder.mkdirs();
            }
            CustomPageDependenciesResolver.removePageLibTempFolder(this.pageName);
            PAGES_LIB_TMPDIR.put(this.pageName, this.libTempFolder);
            return this.loadLibraries(customPageLibDirectory);
        }
        return Collections.emptyMap();
    }

    private Map<String, byte[]> loadLibraries(File customPageLibDirectory) {
        final HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        try {
            Files.walkFileTree(customPageLibDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    File currentFile = file.toFile();
                    result.put(currentFile.getName(), FileUtils.readFileToByteArray((File)currentFile));
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static File removePageLibTempFolder(String pageName) {
        File libTempFolder;
        block3: {
            libTempFolder = PAGES_LIB_TMPDIR.remove(pageName);
            if (libTempFolder != null) {
                try {
                    FileUtils.deleteDirectory((File)libTempFolder);
                }
                catch (IOException e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("The custom page temporary lib directory " + libTempFolder.getPath() + " cannot be deleted. This is likely to be due to a JDK bug on Windows. You can safely delete it after a server restart.");
                }
            }
        }
        return libTempFolder;
    }

    public File getTempFolder() {
        if (this.libTempFolder == null) {
            throw new IllegalStateException("Custom page dependencies must be resolved first.");
        }
        return this.libTempFolder;
    }
}

