/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.page;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.bonitasoft.console.common.server.page.PageReference;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.page.PageURL;
import org.bonitasoft.engine.session.APISession;

public class PageMappingService {
    public PageReference getPage(HttpServletRequest request, APISession apiSession, String mappingKey, Locale locale, boolean executeAuthorizationRules) throws BonitaException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, String[]> parametersMapCopy = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String[])((String[])e.getValue()).clone()));
        context.put("queryParameters", (Serializable)((Object)parametersMapCopy));
        context.put("locale", locale.toString());
        context.put("contextPath", request.getContextPath());
        PageAPI pageAPI = this.getPageAPI(apiSession);
        PageURL pageURL = pageAPI.resolvePageOrURL(mappingKey, context, executeAuthorizationRules);
        return new PageReference(pageURL.getPageId(), pageURL.getUrl());
    }

    protected PageAPI getPageAPI(APISession apiSession) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getCustomPageAPI((APISession)apiSession);
    }
}

