/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.preferences.constants;

import java.io.File;
import java.net.URI;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstants;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsImpl;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsTenancyImpl;
import org.bonitasoft.engine.io.IOUtil;

public class WebBonitaConstantsUtils {
    private static WebBonitaConstantsUtils tenantConstantsUtils = new WebBonitaConstantsUtils(new WebBonitaConstantsTenancyImpl());
    private static WebBonitaConstantsUtils platformConstantsUtils = new WebBonitaConstantsUtils(new WebBonitaConstantsImpl());
    private WebBonitaConstants webBonitaConstants;

    public WebBonitaConstantsUtils(WebBonitaConstants constants) {
        this.webBonitaConstants = constants;
    }

    public static WebBonitaConstantsUtils getTenantInstance() {
        return tenantConstantsUtils;
    }

    public static WebBonitaConstantsUtils getPlatformInstance() {
        return platformConstantsUtils;
    }

    public File getTempFolder() {
        File tempFolder = new File(WebBonitaConstants.rootTempDir);
        if (!tempFolder.exists()) {
            IOUtil.createTempDirectory((URI)tempFolder.toURI());
        }
        return this.getFolder(this.webBonitaConstants.getTempFolderPath());
    }

    public File getPagesFolder() {
        return this.getFolder(this.webBonitaConstants.getPagesTempFolderPath());
    }

    public File getFormsWorkFolder() {
        return this.getFolder(this.webBonitaConstants.getFormsTempFolderPath());
    }

    public File geBDMWorkFolder() {
        return this.getFolder(this.webBonitaConstants.getBDMTempFolderPath());
    }

    private File getFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }
}

