/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.bonitasoft.console.common.server.servlet.DocumentDownloadServlet;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.FormsResourcesUtils;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentImageServlet
extends DocumentDownloadServlet {
    private static final long serialVersionUID = -2397573068771431608L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentImageServlet.class.getName());

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block42: {
            filePath = request.getParameter("filePath");
            fileName = request.getParameter("fileName");
            resourcePath = request.getParameter("resourceFileName");
            documentId = request.getParameter("document");
            apiSession = (APISession)request.getSession().getAttribute("apiSession");
            content = null;
            if (filePath != null) {
                tempFolderAccessor = new BonitaHomeFolderAccessor();
                try {
                    fileContent = tempFolderAccessor.retrieveUploadedTempContent(FilenameUtils.separatorsToSystem((String)filePath));
                    if (fileName == null) {
                        fileName = fileContent.getFileName();
                    }
                    inputStream = fileContent.getInputStream();
                    try {
                        content = this.getFileContent(inputStream, filePath, fileContent.getSize());
                        break block42;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (BonitaException e) {
                    throw new ServletException(e.getMessage());
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (documentId != null) {
                try {
                    processAPI = this.bpmEngineAPIUtil.getProcessAPI(apiSession);
                    try {
                        document = processAPI.getDocument(Long.valueOf(documentId).longValue());
                        fileName = document.getContentFileName();
                        contentStorageId = document.getContentStorageId();
                    }
                    catch (DocumentNotFoundException dnfe) {
                        archivedDocument = processAPI.getArchivedVersionOfProcessDocument(Long.valueOf(documentId).longValue());
                        fileName = archivedDocument.getContentFileName();
                        contentStorageId = archivedDocument.getContentStorageId();
                    }
                    if (contentStorageId == null || contentStorageId.isEmpty()) ** GOTO lbl85
                    content = processAPI.getDocumentContent(contentStorageId);
                }
                catch (Exception e) {
                    errorMessage = "Error while retrieving the document  with ID " + documentId + " from the engine.";
                    if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                        DocumentImageServlet.LOGGER.error(errorMessage, (Throwable)e);
                    }
                    throw new ServletException(errorMessage, (Throwable)e);
                }
            } else if (resourcePath != null) {
                processIDStr = request.getParameter("process");
                instanceIDStr = request.getParameter("instance");
                taskIdStr = request.getParameter("task");
                processDefinitionID = -1L;
                try {
                    if (processIDStr != null) {
                        processDefinitionID = Long.parseLong(processIDStr);
                    } else if (taskIdStr != null) {
                        processDefinitionID = this.getProcessDefinitionIDFromActivityInstanceID(apiSession, Long.parseLong(taskIdStr));
                    } else if (instanceIDStr != null) {
                        processDefinitionID = this.getProcessDefinitionIDFromProcessInstanceID(apiSession, Long.parseLong(instanceIDStr));
                    } else {
                        errorMessage = "Error while retrieving the resource " + resourcePath + " : Either a process, instance or task is required in the URL";
                        if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                            DocumentImageServlet.LOGGER.error(errorMessage);
                        }
                        throw new ServletException(errorMessage);
                    }
                    processDeployementDate = this.getMigrationDate(apiSession, processDefinitionID);
                    if (processDeployementDate == null) {
                        processDeployementDate = this.getProcessDefinitionDate(apiSession, processDefinitionID);
                    }
                    if (!(resource = new File(processDir = FormsResourcesUtils.getApplicationResourceDir(apiSession, processDefinitionID, processDeployementDate), "documents" + File.separator + resourcePath)).exists()) {
                        errorMessage = "The target resource does not exist " + resource.getAbsolutePath();
                        if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                            DocumentImageServlet.LOGGER.error(errorMessage);
                        }
                        throw new IOException(errorMessage);
                    }
                    fileName = resource.getName();
                    resourceInputStream = new FileInputStream(resource);
                    content = this.getFileContent(resourceInputStream, fileName, resource.length());
                }
                catch (Exception e) {
                    errorMessage = "Error while retrieving the resource " + resourcePath;
                    if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                        DocumentImageServlet.LOGGER.error(errorMessage, (Throwable)e);
                    }
                    throw new ServletException(errorMessage, (Throwable)e);
                }
            } else {
                errorMessage = "Error while getting the file. either a document, a filePath or a resourcePath parameter is required.";
                if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                    DocumentImageServlet.LOGGER.error("Error while getting the file. either a document, a filePath or a resourcePath parameter is required.");
                }
                throw new ServletException("Error while getting the file. either a document, a filePath or a resourcePath parameter is required.");
            }
        }
        contentType = URLConnection.guessContentTypeFromName(fileName);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (fileName != null) {
            try {
                encodedfileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
                userAgent = request.getHeader("User-Agent");
                if (userAgent != null && userAgent.contains("Firefox")) {
                    response.setHeader("Content-Disposition", "inline; filename*=UTF-8''" + encodedfileName);
                } else {
                    response.setHeader("Content-Disposition", "inline; filename=\"" + encodedfileName + "\"; filename*=UTF-8''" + encodedfileName);
                }
                if (content != null) {
                    response.setContentLength(content.length);
                    out = response.getOutputStream();
                    out.write(content);
                }
            }
            catch (IOException e) {
                if (DocumentImageServlet.LOGGER.isErrorEnabled()) {
                    DocumentImageServlet.LOGGER.error("Error while generating the response.", (Throwable)e);
                }
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

