/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.bonitasoft.console.common.server.login.filter.MultiReadHttpServletRequest;
import org.bonitasoft.console.common.server.utils.DocumentUtil;
import org.bonitasoft.engine.api.PlatformAPIAccessor;
import org.bonitasoft.engine.api.TemporaryContentAPI;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.session.SessionNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUploadServlet
extends HttpServlet {
    protected static final long serialVersionUID = -948661031179067420L;
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)FileUploadServlet.class.getName());
    protected String uploadDirectoryPath = null;
    public static final String RESPONSE_SEPARATOR = "::";
    protected static final String SUPPORTED_EXTENSIONS_PARAM = "SupportedExtensions";
    protected static final String SUPPORTED_EXTENSIONS_SEPARATOR = ",";
    protected static final String RETURN_ORIGINAL_FILENAME_PARAM = "ReturnOriginalFilename";
    protected static final String CHECK_UPLOADED_FILE_SIZE = "CheckUploadedFileSize";
    protected static final String CHECK_UPLOADED_IMAGE_SIZE = "CheckUploadedImageSize";
    protected static final String RESPONSE_CONTENT_TYPE_PARAM = "ContentType";
    protected static final String TEXT_CONTENT_TYPE = "text";
    protected static final String JSON_CONTENT_TYPE = "json";
    protected static final String TEMP_PATH_RESPONSE_ATTRIBUTE = "tempPath";
    protected static final String FILE_NAME_RESPONSE_ATTRIBUTE = "filename";
    protected static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    public static final int MEGABYTE = 0x100000;
    public static final int KILOBYTE = 1024;
    protected String[] supportedExtensionsList = new String[0];
    protected boolean alsoReturnOriginalFilename = false;
    protected boolean checkUploadedFileSize = false;
    protected boolean checkUploadedImageSize = false;
    protected String responseContentType = "text";
    private ObjectMapper objectMapper = new ObjectMapper();
    protected TemporaryContentAPI temporaryContentAPI;

    public void init() throws ServletException {
        String supportedExtensionsParam = this.getInitParameter(SUPPORTED_EXTENSIONS_PARAM);
        if (supportedExtensionsParam != null) {
            this.supportedExtensionsList = supportedExtensionsParam.split(SUPPORTED_EXTENSIONS_SEPARATOR);
        }
        this.alsoReturnOriginalFilename = Boolean.parseBoolean(this.getInitParameter(RETURN_ORIGINAL_FILENAME_PARAM));
        String responseContentTypeParam = this.getInitParameter(RESPONSE_CONTENT_TYPE_PARAM);
        if (responseContentTypeParam != null) {
            this.responseContentType = responseContentTypeParam;
        }
        this.checkUploadedFileSize = Boolean.parseBoolean(this.getInitParameter(CHECK_UPLOADED_FILE_SIZE));
        this.checkUploadedImageSize = Boolean.parseBoolean(this.getInitParameter(CHECK_UPLOADED_IMAGE_SIZE));
        this.temporaryContentAPI = this.getTemporaryContentAPI();
    }

    protected TemporaryContentAPI getTemporaryContentAPI() {
        try {
            return PlatformAPIAccessor.getTemporaryContentAPI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void defineUploadDirectoryPath(HttpServletRequest var1) throws SessionNotFoundException;

    protected abstract void setUploadMaxSize(ServletFileUpload var1, HttpServletRequest var2);

    protected void setUploadDirectoryPath(String uploadDirectoryPath) {
        this.uploadDirectoryPath = uploadDirectoryPath;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=UTF-8");
        try (PrintWriter responsePW = null;){
            List items;
            this.defineUploadDirectoryPath(request);
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                return;
            }
            File targetDirectory = new File(this.uploadDirectoryPath);
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            responsePW = response.getWriter();
            DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
            ServletFileUpload serviceFileUpload = this.createServletFileUpload((FileItemFactory)fileItemFactory);
            this.setUploadMaxSize(serviceFileUpload, request);
            try {
                items = serviceFileUpload.parseRequest(request);
            }
            catch (OutOfMemoryError e) {
                throw new FileUploadBase.SizeLimitExceededException("The file exceeds its maximum permitted size.", 0L, 0L);
            }
            for (FileItem item : items) {
                String responseString;
                if (item.isFormField()) continue;
                String fileName = DocumentUtil.sanitizeFilename(item.getName());
                if (!this.isSupportedExtension(fileName)) {
                    this.outputMediaTypeError(response, responsePW);
                    return;
                }
                String uploadedFileKey = this.storeTempFile(fileName, item);
                if (request instanceof MultiReadHttpServletRequest) {
                    ((MultiReadHttpServletRequest)request).cleanMultipartTempContent();
                }
                if (JSON_CONTENT_TYPE.equals(this.responseContentType)) {
                    responseString = this.generateResponseJson(request, fileName, item.getContentType(), uploadedFileKey);
                } else if (TEXT_CONTENT_TYPE.equals(this.responseContentType)) {
                    responseString = this.generateResponseString(request, fileName, uploadedFileKey);
                } else {
                    throw new ServletException("Unsupported content type in servlet configuration : " + this.responseContentType);
                }
                responsePW.print(responseString);
                responsePW.flush();
                break;
            }
        }
    }

    protected String storeTempFile(String fileName, FileItem item) throws Exception {
        this.temporaryContentAPI = PlatformAPIAccessor.getTemporaryContentAPI();
        return this.temporaryContentAPI.storeTempFile(new FileContent(fileName, item.getInputStream(), item.getContentType()));
    }

    private void generateFileTooBigError(HttpServletResponse response, PrintWriter responsePW, String message) throws JsonProcessingException {
        response.setStatus(413);
        if (JSON_CONTENT_TYPE.equals(this.responseContentType)) {
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("type", "EntityTooLarge");
            errorResponse.put("message", message);
            errorResponse.put("statusCode", 413);
            responsePW.print(this.objectMapper.writeValueAsString(errorResponse));
            responsePW.flush();
        }
    }

    protected ServletFileUpload createServletFileUpload(FileItemFactory fileItemFactory) {
        return new ServletFileUpload(fileItemFactory);
    }

    protected String generateResponseString(HttpServletRequest request, String fileName, String uploadedFileName) throws Exception {
        Object responseString = uploadedFileName;
        if (this.alsoReturnOriginalFilename) {
            responseString = (String)responseString + RESPONSE_SEPARATOR + this.getFilenameLastSegment(fileName);
        }
        return responseString;
    }

    protected String generateResponseJson(HttpServletRequest request, String fileName, String contentType, String uploadedFileName) throws Exception {
        HashMap<String, Serializable> responseMap = new HashMap<String, Serializable>();
        this.fillJsonResponseMap(request, responseMap, fileName, contentType, uploadedFileName);
        return this.objectMapper.writeValueAsString(responseMap);
    }

    protected void fillJsonResponseMap(HttpServletRequest request, Map<String, Serializable> responseMap, String fileName, String contentType, String uploadedFileName) {
        if (this.alsoReturnOriginalFilename) {
            responseMap.put(FILE_NAME_RESPONSE_ATTRIBUTE, (Serializable)((Object)this.getFilenameLastSegment(fileName)));
        }
        responseMap.put(TEMP_PATH_RESPONSE_ATTRIBUTE, (Serializable)((Object)uploadedFileName));
        responseMap.put(CONTENT_TYPE_ATTRIBUTE, (Serializable)((Object)contentType));
    }

    protected String getFilenameLastSegment(String fileName) {
        int slashPos = fileName.lastIndexOf("/");
        if (slashPos == -1) {
            slashPos = fileName.lastIndexOf("\\");
        }
        return fileName.substring(slashPos + 1);
    }

    protected void outputMediaTypeError(HttpServletResponse response, PrintWriter responsePW) {
        response.setStatus(415);
        responsePW.print("Extension not supported.");
        responsePW.flush();
    }

    protected boolean isSupportedExtension(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (this.supportedExtensionsList.length < 1) {
            return true;
        }
        for (String extension : this.supportedExtensionsList) {
            if (!fileName.toLowerCase().endsWith("." + extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

