/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.servlet.IconContent;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIMalformedUrlException;
import org.bonitasoft.web.toolkit.client.common.exception.http.ServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IconServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)IconServlet.class.getName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String iconIdPath = request.getPathInfo();
        if (iconIdPath == null || iconIdPath.isEmpty()) {
            response.setStatus(400);
            return;
        }
        Long iconId = this.parseLong(iconIdPath);
        if (iconId == null) {
            response.setStatus(400);
            return;
        }
        Optional<IconContent> iconContent = this.retrieveIcon(iconId, (APISession)request.getSession().getAttribute("apiSession"));
        if (!iconContent.isPresent()) {
            response.setStatus(404);
            return;
        }
        response.setContentType(iconContent.get().getMimeType());
        response.setCharacterEncoding("UTF-8");
        try {
            this.setHeaders(request, response, iconId);
        }
        catch (UnsupportedEncodingException e) {
            this.logAndThrowException(e, "Error while generating the headers.");
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setContentLength(iconContent.get().getContent().length);
            out.write(iconContent.get().getContent());
        }
        catch (IOException e) {
            this.logAndThrowException(e, "Error while generating the response.");
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            response.setStatus(400);
            return;
        }
        Long entityId = this.parseLong(pathInfo);
        if (entityId == null) {
            response.setStatus(400);
            return;
        }
        try {
            this.deleteIcon(entityId, (APISession)request.getSession().getAttribute("apiSession"), request);
        }
        catch (APIItemNotFoundException e) {
            response.setStatus(404);
            return;
        }
        catch (APIMalformedUrlException e) {
            response.setStatus(400);
            return;
        }
        catch (ServerException e) {
            response.setStatus(500);
            return;
        }
        try {
            this.setHeaders(request, response, entityId);
        }
        catch (UnsupportedEncodingException e) {
            this.logAndThrowException(e, "Error while generating the headers.");
        }
        response.setStatus(204);
    }

    protected abstract Optional<IconContent> retrieveIcon(Long var1, APISession var2);

    protected abstract void deleteIcon(Long var1, APISession var2, HttpServletRequest var3) throws ServerException;

    private Long parseLong(String iconIdPath) {
        try {
            return Long.valueOf(iconIdPath.substring(1));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void logAndThrowException(IOException e, String msg) throws ServletException {
        LOGGER.error(msg, (Throwable)e);
        throw new ServletException(e.getMessage(), (Throwable)e);
    }

    private void setHeaders(HttpServletRequest request, HttpServletResponse response, Long iconId) throws UnsupportedEncodingException {
        String encodedFileName = URLEncoder.encode(String.valueOf(iconId), StandardCharsets.UTF_8);
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.contains("Firefox")) {
            response.setHeader("Content-Disposition", "inline; filename*=UTF-8''" + encodedFileName);
        } else {
            response.setHeader("Content-Disposition", "inline; filename=\"" + encodedFileName.replaceAll("\\+", " ") + "\"; filename*=UTF-8''" + encodedFileName);
        }
    }
}

