/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.console.common.server.utils.BPMEngineAPIUtil;
import org.bonitasoft.console.common.server.utils.BPMEngineException;
import org.bonitasoft.console.common.server.utils.ProcessAccessor;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsResourcesUtils {
    public static final String FORMS_DIRECTORY_IN_BAR = "resources/forms";
    public static final String UUID_SEPARATOR = "--";
    protected static final BPMEngineAPIUtil bpmEngineAPIUtil = new BPMEngineAPIUtil();
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)FormsResourcesUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void retrieveApplicationFiles(APISession session, long processDefinitionID, Date processDeploymentDate) throws IOException, ProcessDefinitionNotFoundException, InvalidSessionException, RetrieveException, BPMEngineException {
        ProcessAccessor process = new ProcessAccessor(bpmEngineAPIUtil.getProcessAPI(session));
        File formsDir = FormsResourcesUtils.getApplicationResourceDir(session, processDefinitionID, processDeploymentDate);
        if (!formsDir.exists()) {
            formsDir.mkdirs();
        }
        Map<String, byte[]> formsResources = process.getResources(processDefinitionID, "resources/forms/.*");
        for (Map.Entry<String, byte[]> formResource : formsResources.entrySet()) {
            String filePath = formResource.getKey().substring(FORMS_DIRECTORY_IN_BAR.length() + 1);
            byte[] fileContent = formResource.getValue();
            File formResourceFile = new File(formsDir.getPath() + File.separator + filePath);
            File formResourceFileDir = formResourceFile.getParentFile();
            if (!formResourceFileDir.exists()) {
                formResourceFileDir.mkdirs();
            }
            formResourceFile.createNewFile();
            if (fileContent == null) continue;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(formResourceFile);
                fos.write(fileContent);
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("unable to close file output stream for business archive resource " + formResourceFile.getPath(), (Throwable)e);
                }
            }
        }
    }

    public static synchronized void removeApplicationFiles(APISession session, long processDefinitionID) {
        block3: {
            try {
                ProcessAPI processAPI = bpmEngineAPIUtil.getProcessAPI(session);
                ProcessDefinition processDefinition = processAPI.getProcessDefinition(processDefinitionID);
                String processUUID = processDefinition.getName() + UUID_SEPARATOR + processDefinition.getVersion();
                File formsDir = new File(WebBonitaConstantsUtils.getTenantInstance().getFormsWorkFolder(), processUUID);
                boolean deleted = FormsResourcesUtils.deleteDirectory(formsDir);
                if (!deleted && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("unable to delete the web resources directory " + formsDir.getCanonicalPath() + ". You will be able to delete it manually once the JVM will shutdown");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("Error while deleting the web resources directory for process " + processDefinitionID, (Throwable)e);
            }
        }
    }

    public static File getApplicationResourceDir(APISession session, long processDefinitionID, Date processDeploymentDate) throws InvalidSessionException, ProcessDefinitionNotFoundException, RetrieveException, BPMEngineException {
        ProcessAccessor process = new ProcessAccessor(bpmEngineAPIUtil.getProcessAPI(session));
        ProcessDefinition processDefinition = process.getDefinition(processDefinitionID);
        String processUUID = processDefinition.getName() + UUID_SEPARATOR + processDefinition.getVersion();
        return new File(WebBonitaConstantsUtils.getTenantInstance().getFormsWorkFolder(), processUUID + File.separator + processDeploymentDate.getTime());
    }

    private static boolean deleteDirectory(File directory) {
        boolean success = true;
        if (directory.exists()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    success &= FormsResourcesUtils.deleteDirectory(files[i]);
                    continue;
                }
                success &= files[i].delete();
            }
            success &= directory.delete();
        }
        return success;
    }
}

