/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.DefaultTenantIdException;
import org.bonitasoft.engine.api.ProfileAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.profile.ProfileCriterion;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;

public class TenantsManagementUtils {
    public static long defaultTenantId = -1L;

    public static boolean hasProfileForUser(APISession apiSession) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return !TenantsManagementUtils.getProfileApi(apiSession).getProfilesForUser(apiSession.getUserId(), 0, 1, ProfileCriterion.ID_ASC).isEmpty();
    }

    private static ProfileAPI getProfileApi(APISession session) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProfileAPI((APISession)session);
    }

    public static long getDefaultTenantId() {
        if (defaultTenantId == -1L) {
            try {
                APISession session = TenantAPIAccessor.getLoginAPI().login(TenantsManagementUtils.getTechnicalUserUsername(), TenantsManagementUtils.getTechnicalUserPassword());
                defaultTenantId = session.getTenantId();
                TenantAPIAccessor.getLoginAPI().logout(session);
            }
            catch (Exception e) {
                throw new DefaultTenantIdException(e);
            }
        }
        return defaultTenantId;
    }

    public static String getTechnicalUserUsername() {
        return PropertiesFactory.getPlatformTenantConfigProperties().defaultTenantUserName();
    }

    public static String getTechnicalUserPassword() {
        return PropertiesFactory.getPlatformTenantConfigProperties().defaultTenantPassword();
    }

    public static boolean isDefaultTenantPaused() throws Exception {
        APISession apiSession = null;
        try {
            apiSession = TenantAPIAccessor.getLoginAPI().login(TenantsManagementUtils.getTechnicalUserUsername(), TenantsManagementUtils.getTechnicalUserPassword());
            boolean bl = TenantAPIAccessor.getTenantAdministrationAPI((APISession)apiSession).isPaused();
            return bl;
        }
        finally {
            if (apiSession != null) {
                TenantAPIAccessor.getLoginAPI().logout(apiSession);
            }
        }
    }
}

