/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.common.server.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.bonitasoft.console.common.server.utils.UrlValue;

public class UrlBuilder {
    private final URIBuilder uriBuilder;
    private final List<NameValuePair> parameters = new LinkedList<NameValuePair>();

    public UrlBuilder(String urlString) {
        URI uri;
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.uriBuilder = new URIBuilder(uri);
        this.uriBuilder.setCharset(Consts.UTF_8);
        if (uri.getRawQuery() != null) {
            this.parameters.addAll(URLEncodedUtils.parse((String)uri.getRawQuery(), (Charset)StandardCharsets.UTF_8));
        }
    }

    public void appendParameter(String key, String ... values) {
        if (!this.isParameterAlreadyDefined(this.parameters, key)) {
            this.parameters.add((NameValuePair)new BasicNameValuePair(key, new UrlValue(values).toString()));
        }
    }

    public void removeParameter(String key) {
        this.parameters.removeIf(param -> param.getName().equals(key));
    }

    private boolean isParameterAlreadyDefined(List<NameValuePair> params, String key) {
        for (NameValuePair param : params) {
            if (!param.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public void appendParameters(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> next : parameters.entrySet()) {
            this.appendParameter(next.getKey(), new UrlValue(next.getValue()).toString());
        }
    }

    public String build() {
        if (!this.parameters.isEmpty()) {
            this.uriBuilder.setParameters(this.parameters);
        } else {
            this.uriBuilder.removeQuery();
        }
        return this.uriBuilder.toString();
    }
}

