/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.service;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.server.service.ConsoleService;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.identity.ImportPolicy;
import org.bonitasoft.engine.identity.InvalidOrganizationFileFormatException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.server.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationImportService
extends ConsoleService {
    public static final String TOKEN = "/organization/import";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OrganizationImportService.class.getName());
    private static final String FILE_UPLOAD = "organizationDataUpload";
    private static final String IMPORT_POLICY_PARAM_NAME = "importPolicy";

    @Override
    public Object run() {
        BonitaHomeFolderAccessor tenantFolder = new BonitaHomeFolderAccessor();
        try {
            byte[] organizationContent = this.getOrganizationContent(tenantFolder);
            this.getIdentityAPI().importOrganizationWithWarnings(new String(organizationContent), this.getImportPolicy());
        }
        catch (InvalidSessionException e) {
            this.getHttpResponse().setStatus(401);
            String message = AbstractI18n.t_("Session expired. Please log in again.");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(message, (Object)e.getMessage());
            }
            throw new ServiceException(TOKEN, message, e);
        }
        catch (IllegalArgumentException | InvalidOrganizationFileFormatException e) {
            this.getHttpResponse().setStatus(400);
            String message = AbstractI18n.t_("Can't import organization. Please check that your file is well-formed.");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(message, (Object)e.getMessage());
            }
            throw new ServiceException(TOKEN, message, e);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException(TOKEN, AbstractI18n.t_("Can't import organization"), e);
        }
        finally {
            this.cleanTempContent(tenantFolder);
        }
        return "";
    }

    private ImportPolicy getImportPolicy() {
        String importPolicyAsString = this.getParameter(IMPORT_POLICY_PARAM_NAME);
        ImportPolicy importPolicy = ImportPolicy.MERGE_DUPLICATES;
        if (importPolicyAsString != null) {
            importPolicy = ImportPolicy.valueOf((String)importPolicyAsString);
        }
        return importPolicy;
    }

    public byte[] getOrganizationContent(BonitaHomeFolderAccessor tenantFolder) throws IOException, BonitaException {
        try (InputStream xmlStream = tenantFolder.retrieveUploadedTempContent(this.getFileUploadParameter()).getInputStream();){
            byte[] byArray = IOUtils.toByteArray((InputStream)xmlStream);
            return byArray;
        }
    }

    public void cleanTempContent(BonitaHomeFolderAccessor tenantFolder) {
        tenantFolder.removeUploadedTempContent(this.getFileUploadParameter());
    }

    protected IdentityAPI getIdentityAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getIdentityAPI((APISession)this.getSession());
    }

    protected String getFileUploadParameter() {
        return this.getParameter(FILE_UPLOAD);
    }
}

