/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.console.server.service;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.server.service.ConsoleService;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.toolkit.server.ServiceException;

public class ProcessActorImportService
extends ConsoleService {
    public static final String TOKEN = "/bpm/process/importActors";

    @Override
    public Object run() {
        BonitaHomeFolderAccessor tenantFolder = new BonitaHomeFolderAccessor();
        try {
            FileContent xmlFile = tenantFolder.retrieveUploadedTempContent(this.getFileUploadParameter());
            APISession apiSession = this.getSession();
            ProcessAPI processAPI = TenantAPIAccessor.getProcessAPI((APISession)apiSession);
            try (InputStream xmlStream = xmlFile.getInputStream();){
                byte[] actorsXmlContent = IOUtils.toByteArray((InputStream)xmlStream);
                processAPI.importActorMapping(Long.valueOf(this.getParameter("process_id")).longValue(), actorsXmlContent);
            }
        }
        catch (IOException | BonitaException e) {
            throw new ServiceException(TOKEN, e.getMessage());
        }
        finally {
            tenantFolder.removeUploadedTempContent(this.getFileUploadParameter());
        }
        return "";
    }

    protected String getFileUploadParameter() {
        return this.getParameter("file");
    }
}

