/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.livingapps;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.console.common.server.auth.AuthenticationManager;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerFactory;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerNotFoundException;
import org.bonitasoft.console.common.server.login.HttpServletRequestAccessor;
import org.bonitasoft.console.common.server.login.utils.LoginUrl;
import org.bonitasoft.console.common.server.login.utils.RedirectUrl;
import org.bonitasoft.console.common.server.login.utils.RedirectUrlBuilder;
import org.bonitasoft.console.common.server.page.CustomPageRequestModifier;
import org.bonitasoft.console.common.server.page.PageRenderer;
import org.bonitasoft.console.common.server.page.ResourceRenderer;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.SessionUtil;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.business.application.ApplicationPageNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.page.PageNotFoundException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.livingapps.ApplicationModelFactory;
import org.bonitasoft.livingapps.ApplicationRouter;
import org.bonitasoft.livingapps.exception.CreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivingApplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = -3911437607969651000L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LivingApplicationServlet.class.getName());
    protected CustomPageRequestModifier customPageRequestModifier = new CustomPageRequestModifier();

    protected void service(HttpServletRequest hsRequest, HttpServletResponse hsResponse) throws ServletException, IOException {
        APISession session = this.getSession(hsRequest);
        if (this.isPageUrlWithoutFinalSlash(hsRequest)) {
            this.customPageRequestModifier.redirectToValidPageUrl(hsRequest, hsResponse);
            return;
        }
        try {
            this.createApplicationRouter(session).route(hsRequest, hsResponse, session, this.getPageRenderer(), this.getResourceRenderer(), new BonitaHomeFolderAccessor());
        }
        catch (ApplicationPageNotFoundException | PageNotFoundException | CreationException e) {
            hsResponse.sendError(404, e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException | BonitaException e) {
            if (LOGGER.isWarnEnabled()) {
                String message = "Error while trying to display application " + hsRequest.getPathInfo();
                LOGGER.warn(message, e);
            }
            if (!hsResponse.isCommitted()) {
                hsResponse.sendError(500);
            }
            throw new ServletException(e);
        }
        catch (InvalidSessionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invalid Bonita engine session.", (Throwable)e);
            }
            SessionUtil.sessionLogout(hsRequest.getSession());
            HttpServletRequestAccessor requestAccessor = new HttpServletRequestAccessor(hsRequest);
            LoginUrl loginURL = new LoginUrl(this.getAuthenticationManager(), this.makeRedirectUrl(requestAccessor).getUrl(), requestAccessor);
            hsResponse.sendRedirect(loginURL.getLocation());
        }
    }

    ApplicationRouter createApplicationRouter(APISession session) throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return new ApplicationRouter(new ApplicationModelFactory(TenantAPIAccessor.getLivingApplicationAPI((APISession)session), TenantAPIAccessor.getCustomPageAPI((APISession)session), TenantAPIAccessor.getProfileAPI((APISession)session)));
    }

    private boolean isPageUrlWithoutFinalSlash(HttpServletRequest request) {
        return request.getPathInfo() == null || request.getPathInfo().matches("/[^/]+/[^/]+") || request.getPathInfo().matches("/[^/]+");
    }

    APISession getSession(HttpServletRequest hsRequest) {
        return (APISession)hsRequest.getSession().getAttribute("apiSession");
    }

    PageRenderer getPageRenderer() {
        return new PageRenderer(this.getResourceRenderer());
    }

    ResourceRenderer getResourceRenderer() {
        return new ResourceRenderer();
    }

    protected RedirectUrl makeRedirectUrl(HttpServletRequestAccessor httpRequest) {
        RedirectUrlBuilder builder = new RedirectUrlBuilder(httpRequest.getRequestedUri());
        builder.appendParameters(httpRequest.getParameterMap());
        return builder.build();
    }

    protected AuthenticationManager getAuthenticationManager() throws ServletException {
        try {
            return AuthenticationManagerFactory.getAuthenticationManager();
        }
        catch (AuthenticationManagerNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

