/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.business.data.BusinessDataRepositoryDeploymentException;
import org.bonitasoft.engine.business.data.InvalidBusinessDataModelException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.TenantStatusException;
import org.bonitasoft.engine.exception.UnavailableLockException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.bdm.BusinessDataModelItem;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.rest.server.api.tenant.TenantResourceItem;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class BusinessDataModelResource
extends CommonResource {
    private final TenantAdministrationAPI tenantAdministrationAPI;
    private final BonitaHomeFolderAccessor bonitaHomeFolderAccessor;

    public BusinessDataModelResource(TenantAdministrationAPI tenantAdministrationAPI, BonitaHomeFolderAccessor bonitaHomeFolderAccessor) {
        this.bonitaHomeFolderAccessor = bonitaHomeFolderAccessor;
        this.tenantAdministrationAPI = tenantAdministrationAPI;
    }

    @Post(value="json")
    @Deprecated(since="9.0.0")
    public TenantResourceItem addBDM(BusinessDataModelItem businessDataModelItem) {
        if (!this.isTenantPaused()) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN, new APIException("Unable to install the Business Data Model. Please pause the BPM Services first. Go to Configuration > BPM Services."));
            return null;
        }
        try {
            FileContent businessDataModel = this.getBusinessDataModel(businessDataModelItem);
            byte[] businessDataModelContent = this.getBusinessDataModelContent(businessDataModel.getInputStream());
            this.tenantAdministrationAPI.updateBusinessDataModel(businessDataModelContent);
            TenantResourceItem tenantResourceItem = new TenantResourceItem(this.tenantAdministrationAPI.getBusinessDataModelResource(), businessDataModel.getFileName());
            return tenantResourceItem;
        }
        catch (APIForbiddenException e) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN, e);
            TenantResourceItem businessDataModelContent = null;
            return businessDataModelContent;
        }
        catch (InvalidBusinessDataModelException e) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e, "Invalid Business Data Model content");
            TenantResourceItem businessDataModelContent = null;
            return businessDataModelContent;
        }
        catch (BusinessDataRepositoryDeploymentException e) {
            throw new APIException("An error has occurred when deploying Business Data Model.", (Throwable)e);
        }
        catch (TenantStatusException | InvalidSessionException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnavailableLockException) {
                this.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE, cause, cause.getMessage());
                TenantResourceItem tenantResourceItem = null;
                return tenantResourceItem;
            }
            throw e;
        }
        finally {
            this.bonitaHomeFolderAccessor.removeUploadedTempContent(businessDataModelItem.getFileUpload());
        }
    }

    @Get(value="json")
    public TenantResourceItem getBDM() {
        try {
            return new TenantResourceItem(this.tenantAdministrationAPI.getBusinessDataModelResource());
        }
        catch (TenantStatusException | InvalidSessionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
    }

    public boolean isTenantPaused() {
        return this.tenantAdministrationAPI.isPaused();
    }

    private FileContent getBusinessDataModel(BusinessDataModelItem item) {
        try {
            return this.bonitaHomeFolderAccessor.retrieveUploadedTempContent(item.getFileUpload());
        }
        catch (BonitaException e) {
            throw new APIException("Can't read business data model file", (Throwable)e);
        }
    }

    private byte[] getBusinessDataModelContent(InputStream inputStream) {
        byte[] byArray;
        block8: {
            InputStream inputStream2 = inputStream;
            try {
                byArray = IOUtils.toByteArray((InputStream)inputStream);
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new APIException("Can't read business data model file", (Throwable)e);
                }
            }
            inputStream2.close();
        }
        return byArray;
    }
}

