/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bdm;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.bonitasoft.engine.api.CommandAPI;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataQueryMetadata;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataQueryResult;
import org.bonitasoft.engine.command.CommandExecutionException;
import org.bonitasoft.engine.command.CommandNotFoundException;
import org.bonitasoft.engine.command.CommandParameterizationException;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessDataQueryResource
extends CommonResource {
    public static final String COMMAND_NAME = "getBusinessDataByQueryCommand";
    private final CommandAPI commandAPI;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BusinessDataQueryResource.class.getName());

    public BusinessDataQueryResource(CommandAPI commandAPI) {
        this.commandAPI = commandAPI;
        this.setConditional(false);
    }

    @Get(value="json")
    public void getProcessBusinessDataQuery() throws CommandNotFoundException, CommandParameterizationException, CommandExecutionException, IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Integer searchPageNumber = this.getSearchPageNumber();
        Integer searchPageSize = this.getSearchPageSize();
        parameters.put("queryName", this.getQueryParameter(true));
        parameters.put("queryParameters", (Serializable)((Object)this.getSearchFilters()));
        parameters.put("entityClassName", this.getPathParam("className"));
        parameters.put("startIndex", searchPageNumber * searchPageSize);
        parameters.put("maxResults", searchPageSize);
        parameters.put("businessDataURIPattern", "/API/bdm/businessData/{className}/{id}/{field}");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing business Data Query: " + parameters.get("queryName"));
            LOGGER.debug("entityClassName: " + parameters.get("entityClassName"));
            LOGGER.debug("queryParameters: " + ((Serializable)parameters.get("queryParameters")).toString());
            LOGGER.debug("startIndex: " + parameters.get("startIndex"));
            LOGGER.debug("maxResults: " + parameters.get("maxResults"));
        }
        BusinessDataQueryResult businessDataQueryResult = (BusinessDataQueryResult)this.commandAPI.execute(COMMAND_NAME, parameters);
        Representation representation = this.getConverterService().toRepresentation((Object)businessDataQueryResult.getJsonResults(), MediaType.APPLICATION_JSON);
        representation.setCharacterSet(CharacterSet.UTF_8);
        this.getResponse().setEntity(representation);
        BusinessDataQueryMetadata businessDataQueryMetadata = businessDataQueryResult.getBusinessDataQueryMetadata();
        if (businessDataQueryMetadata != null) {
            this.setContentRange(searchPageNumber, searchPageSize, businessDataQueryMetadata.getCount());
        }
    }
}

