/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.cases;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.process.ProcessInstanceCriterion;
import org.bonitasoft.web.rest.model.bpm.cases.CaseItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.process.ProcessDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APICase
extends ConsoleAPI<CaseItem>
implements APIHasGet<CaseItem>,
APIHasAdd<CaseItem>,
APIHasSearch<CaseItem>,
APIHasDelete {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("cases");
    }

    @Override
    public CaseItem add(CaseItem caseItem) {
        return this.getCaseDatastore().add(caseItem);
    }

    @Override
    public CaseItem get(APIID id) {
        return this.getCaseDatastore().get(id);
    }

    @Override
    public ItemSearchResult<CaseItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.containsKey("team_manager_id") && filters.containsKey("supervisor_id")) {
            throw new APIException("Can't set those filters at the same time : team_manager_id and supervisor_id");
        }
        return this.getCaseDatastore().search(page, resultsByPage, search, orders, filters);
    }

    @Override
    public String defineDefaultSearchOrder() {
        return ProcessInstanceCriterion.CREATION_DATE_DESC.name();
    }

    @Override
    protected void fillDeploys(CaseItem item, List<String> deploys) {
        this.fillStartedBy(item, deploys);
        this.fillStartedBySubstitute(item, deploys);
        this.fillProcess(item, deploys);
    }

    private void fillStartedBy(CaseItem item, List<String> deploys) {
        if (this.isDeployable("started_by", deploys, item)) {
            item.setDeploy("started_by", this.getUserDatastore().get(item.getStartedByUserId()));
        }
    }

    private void fillStartedBySubstitute(CaseItem item, List<String> deploys) {
        if (this.isDeployable("startedBySubstitute", deploys, item)) {
            item.setDeploy("startedBySubstitute", this.getUserDatastore().get(item.getStartedBySubstituteUserId()));
        }
    }

    private void fillProcess(CaseItem item, List<String> deploys) {
        if (this.isDeployable("processDefinitionId", deploys, item)) {
            item.setDeploy("processDefinitionId", this.getProcessDatastore().get(item.getProcessId()));
        }
    }

    private void fillNumberOfFailedFlowNodesIfFailedCounterExists(CaseItem item, List<String> counters) {
        if (counters.contains("failedFlowNodes")) {
            FlowNodeDatastore flowNodeDatastore = this.getFlowNodeDatastore();
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("state", "failed");
            filters.put("parentCaseId", String.valueOf(item.getId().toLong()));
            item.setAttribute("failedFlowNodes", flowNodeDatastore.count(null, null, filters));
        }
    }

    private void fillNumberOfPendingFlowNodesIfActiveCounterExists(CaseItem item, List<String> counters) {
        if (counters.contains("activeFlowNodes")) {
            FlowNodeDatastore flowNodeDatastore = this.getFlowNodeDatastore();
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("parentCaseId", String.valueOf(item.getId().toLong()));
            item.setAttribute("activeFlowNodes", flowNodeDatastore.count(null, null, filters));
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        this.getCaseDatastore().delete(ids);
    }

    @Override
    protected void fillCounters(CaseItem item, List<String> counters) {
        this.fillNumberOfFailedFlowNodesIfFailedCounterExists(item, counters);
        this.fillNumberOfPendingFlowNodesIfActiveCounterExists(item, counters);
    }

    UserDatastore getUserDatastore() {
        return new UserDatastore(this.getEngineSession());
    }

    ProcessDatastore getProcessDatastore() {
        return new ProcessDatastore(this.getEngineSession());
    }

    FlowNodeDatastore getFlowNodeDatastore() {
        return new FlowNodeDatastore(this.getEngineSession());
    }

    protected CaseDatastore getCaseDatastore() {
        return new CaseDatastore(this.getEngineSession());
    }
}

