/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import java.io.IOException;
import java.util.Date;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.web.rest.server.api.bpm.flownode.TimerEventTrigger;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class TimerEventTriggerResource
extends CommonResource {
    public static final String ID_PARAM_NAME = "id";
    private final ProcessAPI processAPI;

    public TimerEventTriggerResource(ProcessAPI processAPI) {
        this.processAPI = processAPI;
        this.setConditional(false);
    }

    @Get(value="json")
    public void searchTimerEventTriggers() {
        try {
            Long caseId = this.getLongParameter("caseId", true);
            SearchResult searchResult = this.processAPI.searchTimerEventTriggerInstances(caseId.longValue(), this.buildSearchOptions());
            Representation representation = this.getConverterService().toRepresentation((Object)searchResult.getResult(), MediaType.APPLICATION_JSON);
            representation.setCharacterSet(CharacterSet.UTF_8);
            this.getResponse().setEntity(representation);
            this.setContentRange(searchResult);
        }
        catch (IOException | BonitaException e) {
            throw new APIException(e);
        }
    }

    @Put(value="json")
    public TimerEventTrigger updateTimerEventTrigger(TimerEventTrigger trigger) throws Exception {
        String triggerId = this.getAttribute(ID_PARAM_NAME);
        if (triggerId == null) {
            throw new APIException("Attribute 'id' is mandatory");
        }
        long timerEventTriggerInstanceId = Long.parseLong(triggerId);
        Date executionDate = new Date(trigger.getExecutionDate());
        return this.createTimerEventTrigger(this.processAPI.updateExecutionDateOfTimerEventTriggerInstance(timerEventTriggerInstanceId, executionDate).getTime());
    }

    private TimerEventTrigger createTimerEventTrigger(long executionDate) {
        return new TimerEventTrigger(executionDate);
    }

    @Override
    public String getAttribute(String attributeName) {
        return super.getAttribute(attributeName);
    }
}

